/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.Embedded;
import io.requery.Entity;
import io.requery.Superclass;
import io.requery.processor.ElementValidator;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.EntityElement;
import io.requery.processor.EntityElementDelegate;
import io.requery.processor.EntityGenerator;
import io.requery.processor.EntityGraph;
import io.requery.processor.EntityGraphValidator;
import io.requery.processor.EntityType;
import io.requery.processor.Mirrors;
import io.requery.processor.ModelGenerator;
import io.requery.processor.SourceGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.persistence.Embeddable;
import javax.persistence.MappedSuperclass;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"io.requery.*", "javax.persistence.*"})
@SupportedOptions(value={"generate.model", "generate.always", "generate.jpa"})
public final class EntityProcessor
extends AbstractProcessor {
    static final String GENERATE_MODEL = "generate.model";
    static final String GENERATE_ALWAYS = "generate.always";
    static final String GENERATE_JPA = "generate.jpa";
    private Map<String, EntityGraph> graphs;
    private Map<TypeElement, EntityElement> superTypes;
    private Map<TypeElement, EntityElement> embeddedTypes;
    private Set<String> generatedModelPackages;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.embeddedTypes = new LinkedHashMap<TypeElement, EntityElement>();
        this.generatedModelPackages = new LinkedHashSet<String>();
        this.graphs = new LinkedHashMap<String, EntityGraph>();
        this.superTypes = new LinkedHashMap<TypeElement, EntityElement>();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<ElementValidator> results;
        HashMap entities = new HashMap();
        Types types = this.processingEnv.getTypeUtils();
        LinkedHashSet<? extends TypeElement> annotationElements = new LinkedHashSet<TypeElement>(annotations);
        for (TypeElement typeElement2 : annotationElements) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement2)) {
                this.typeElementOf(element).ifPresent(typeElement -> {
                    EntityElement entity = null;
                    if (this.isEntity((TypeElement)typeElement)) {
                        entity = this.computeType(entities, (TypeElement)typeElement);
                        String model = entity.modelName();
                        this.graphs.computeIfAbsent(model, key -> new EntityGraph(types, this.embeddedTypes)).add(entity);
                    } else if (this.isSuperclass((TypeElement)typeElement)) {
                        entity = this.computeType(this.superTypes, (TypeElement)typeElement);
                    } else if (this.isEmbeddable((TypeElement)typeElement)) {
                        entity = this.computeType(this.embeddedTypes, (TypeElement)typeElement);
                    }
                    if (entity != null) {
                        entity.addAnnotationElement(annotation, (Element)((Object)element));
                    }
                });
            }
        }
        boolean hasErrors = false;
        LinkedHashSet<ElementValidator> linkedHashSet = new LinkedHashSet<ElementValidator>();
        Elements elements = this.processingEnv.getElementUtils();
        for (EntityElement entityElement : entities.values()) {
            TypeElement superElement;
            void var11_28;
            if (((TypeElement)entityElement.element()).getKind() == ElementKind.INTERFACE) {
                LinkedList<? extends TypeMirror> linkedList = new LinkedList<TypeMirror>(((TypeElement)entityElement.element()).getInterfaces());
                while (!linkedList.isEmpty()) {
                    TypeMirror mirror = (TypeMirror)linkedList.remove();
                    TypeElement superElement2 = elements.getTypeElement(mirror.toString());
                    if (superElement2 == null) continue;
                    this.mergeSuperType(entityElement, superElement2);
                    linkedList.addAll(superElement2.getInterfaces());
                }
            }
            TypeMirror typeMirror = ((TypeElement)entityElement.element()).getSuperclass();
            while (var11_28.getKind() != TypeKind.NONE && (superElement = elements.getTypeElement(var11_28.toString())) != null) {
                this.mergeSuperType(entityElement, superElement);
                TypeMirror typeMirror2 = superElement.getSuperclass();
            }
            results = entityElement.process(this.processingEnv);
            linkedHashSet.addAll(results);
        }
        for (EntityElement entityElement : this.embeddedTypes.values()) {
            Set<ElementValidator> set = entityElement.process(this.processingEnv);
            linkedHashSet.addAll(set);
        }
        for (EntityGraph entityGraph : this.graphs.values()) {
            EntityGraphValidator entityGraphValidator = new EntityGraphValidator(this.processingEnv, entityGraph);
            results = entityGraphValidator.validate();
            linkedHashSet.addAll(results);
        }
        if (ElementValidator.hasErrors(linkedHashSet)) {
            hasErrors = true;
            StringBuilder stringBuilder = new StringBuilder("Model has error(s) code generation may fail: ");
            linkedHashSet.forEach(validator -> sb.append(validator.toString()));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, stringBuilder);
        }
        LinkedHashSet<EntityGenerator> linkedHashSet2 = new LinkedHashSet<EntityGenerator>();
        if (!hasErrors || this.getOption(GENERATE_ALWAYS, true)) {
            for (EntityDescriptor entityDescriptor : entities.values()) {
                EntityGraph graph3 = this.graphs.get(entityDescriptor.modelName());
                if (graph3 == null) continue;
                linkedHashSet2.add(new EntityGenerator(this.processingEnv, graph3, entityDescriptor, null));
            }
        }
        if (this.getOption(GENERATE_MODEL, true)) {
            String packageName;
            LinkedHashMap<String, Collection> linkedHashMap = new LinkedHashMap<String, Collection>();
            Set set = this.graphs.values().stream().flatMap(graph -> graph.entities().stream()).collect(Collectors.toSet());
            for (EntityDescriptor entity : set) {
                EntityGraph graph4 = this.graphs.get(entity.modelName());
                packageName = this.findModelPackageName(graph4);
                linkedHashMap.computeIfAbsent(packageName, key -> new LinkedHashSet());
                ((Collection)linkedHashMap.get(packageName)).addAll(graph4.entities());
            }
            for (EntityDescriptor entity : entities.values()) {
                EntityGraph graph2 = this.graphs.get(entity.modelName());
                packageName = this.findModelPackageName(graph2);
                if (!entity.generatesAdditionalTypes()) continue;
                linkedHashMap.remove(packageName);
            }
            linkedHashSet2.addAll(linkedHashMap.entrySet().stream().filter(entry -> !((Collection)entry.getValue()).isEmpty()).filter(entry -> !this.generatedModelPackages.contains(entry.getKey())).peek(entry -> this.generatedModelPackages.add((String)entry.getKey())).map(entry -> new ModelGenerator(this.processingEnv, (String)entry.getKey(), (Collection)entry.getValue())).collect(Collectors.toList()));
        }
        for (SourceGenerator sourceGenerator : linkedHashSet2) {
            try {
                sourceGenerator.generate();
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
        return false;
    }

    private void mergeSuperType(EntityElement entity, TypeElement superElement) {
        EntityElement superType = this.superTypes.get(superElement);
        if (superType == null && this.isSuperclass(superElement)) {
            superType = this.computeType(this.superTypes, superElement);
        }
        if (superType != null) {
            superType.process(this.processingEnv);
            entity.merge(superType);
        }
    }

    private EntityElement computeType(Map<TypeElement, EntityElement> map, TypeElement element) {
        return map.computeIfAbsent(element, key -> new EntityElementDelegate(new EntityType(this.processingEnv, (TypeElement)key)));
    }

    private boolean isEntity(TypeElement element) {
        return Mirrors.findAnnotationMirror((Element)element, Entity.class).isPresent() || this.getOption(GENERATE_JPA, true) && Mirrors.findAnnotationMirror((Element)element, javax.persistence.Entity.class).isPresent();
    }

    private boolean isSuperclass(TypeElement element) {
        return Mirrors.findAnnotationMirror((Element)element, Superclass.class).isPresent() || this.getOption(GENERATE_JPA, true) && Mirrors.findAnnotationMirror((Element)element, MappedSuperclass.class).isPresent();
    }

    private boolean isEmbeddable(TypeElement element) {
        return Mirrors.findAnnotationMirror((Element)element, Embedded.class).isPresent() || this.getOption(GENERATE_JPA, true) && Mirrors.findAnnotationMirror((Element)element, Embeddable.class).isPresent();
    }

    private Optional<TypeElement> typeElementOf(Element element) {
        TypeElement typeElement = null;
        switch (element.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: 
            case FIELD: 
            case ENUM_CONSTANT: {
                typeElement = (TypeElement)element.getEnclosingElement();
                break;
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: {
                typeElement = (TypeElement)element;
            }
        }
        return Optional.ofNullable(typeElement);
    }

    private boolean getOption(String key, boolean defaultValue) {
        String value = this.processingEnv.getOptions().get(key);
        return value == null ? defaultValue : Boolean.valueOf(value);
    }

    private String findModelPackageName(EntityGraph graph) {
        String packageName = "";
        List packageNames = graph.entities().stream().map(entity -> entity.typeName().packageName()).collect(Collectors.toList());
        packageNames.sort(null);
        if (packageNames.size() == 1) {
            packageName = (String)packageNames.iterator().next();
        } else {
            String target = (String)packageNames.iterator().next();
            while (target.indexOf(".") != target.lastIndexOf(".")) {
                target = target.substring(0, target.lastIndexOf("."));
                boolean allTypesInPackage = true;
                for (EntityDescriptor entity2 : graph.entities()) {
                    if (entity2.typeName().packageName().startsWith(target)) continue;
                    allTypesInPackage = false;
                }
                if (!allTypesInPackage) continue;
                packageName = target;
                break;
            }
            if ("".equals(packageName)) {
                packageName = target;
            }
        }
        return packageName;
    }
}

