/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.com.squareup.javapoet.CodeBlock;
import io.requery.com.squareup.javapoet.MethodSpec;
import io.requery.com.squareup.javapoet.TypeName;
import io.requery.com.squareup.javapoet.TypeSpec;
import io.requery.processor.CodeGeneration;
import javax.lang.model.element.Modifier;

class GeneratedProperty {
    private final String readName;
    private final String writeName;
    private final TypeName entity;
    private final TypeName typeName;
    private String methodSuffix;
    private String accessSuffix;
    private boolean useMethod;
    private boolean isNullable;
    private boolean isReadOnly;
    private boolean isWriteOnly;

    GeneratedProperty(String propertyName, TypeName entity, TypeName typeName) {
        this(propertyName, propertyName, entity, typeName);
    }

    GeneratedProperty(String readName, String writeName, TypeName entity, TypeName typeName) {
        this.readName = readName;
        this.writeName = writeName;
        this.entity = entity;
        this.typeName = typeName;
        this.methodSuffix = "";
    }

    GeneratedProperty setUseMethod(boolean useMethod) {
        this.useMethod = useMethod;
        return this;
    }

    GeneratedProperty setMethodSuffix(String suffix) {
        this.methodSuffix = suffix;
        return this;
    }

    GeneratedProperty setAccessSuffix(String suffix) {
        this.accessSuffix = suffix;
        return this;
    }

    GeneratedProperty setNullable(boolean nullable) {
        this.isNullable = nullable;
        return this;
    }

    GeneratedProperty setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
        return this;
    }

    GeneratedProperty setWriteOnly(boolean writeOnly) {
        this.isWriteOnly = writeOnly;
        return this;
    }

    void build(TypeSpec.Builder builder) {
        MethodSpec.Builder getMethod = CodeGeneration.overridePublicMethod("get" + this.methodSuffix).addParameter(this.entity, "entity", new Modifier[0]).returns(this.typeName);
        String accessName = "entity" + (this.accessSuffix == null ? "" : this.accessSuffix);
        if (this.isWriteOnly) {
            getMethod.addStatement("throw new UnsupportedOperationException()", new Object[0]);
        } else {
            getMethod.addStatement(this.useMethod ? "return $L.$L()" : "return $L.$L", accessName, this.readName);
        }
        MethodSpec.Builder setMethod = CodeGeneration.overridePublicMethod("set" + this.methodSuffix).addParameter(this.entity, "entity", new Modifier[0]).addParameter(this.typeName, "value", new Modifier[0]);
        if (this.isReadOnly) {
            setMethod.addStatement("throw new UnsupportedOperationException()", new Object[0]);
        } else {
            CodeBlock.Builder block = CodeBlock.builder();
            if (this.isNullable) {
                block.beginControlFlow("if(value != null)", new Object[0]);
            }
            block.addStatement(this.useMethod ? "$L.$L(value)" : "$L.$L = value", accessName, this.writeName);
            if (this.isNullable) {
                block.endControlFlow();
            }
            setMethod.addCode(block.build());
        }
        builder.addMethod(getMethod.build());
        builder.addMethod(setMethod.build());
    }
}

