/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.processor.Mirrors;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

enum ImmutableAnnotationKind {
    AUTOVALUE("com.google.auto.value.AutoValue"),
    AUTOPARCEL("auto.parcel.AutoParcel"),
    IMMUTABLE("org.immutables.value.Value.Immutable"){

        @Override
        Set<String> getMemberAnnotations() {
            return Collections.singleton("org.immutables.value.Value.Default");
        }
    };

    private final String annotationName;

    static Optional<ImmutableAnnotationKind> of(Element element) {
        return Stream.of(ImmutableAnnotationKind.values()).filter(type -> type.isPresent(element)).findFirst();
    }

    private ImmutableAnnotationKind(String name) {
        this.annotationName = name;
    }

    String getAnnotationName() {
        return this.annotationName;
    }

    Set<String> getMemberAnnotations() {
        return Collections.emptySet();
    }

    boolean isPresent(Element element) {
        return Mirrors.findAnnotationMirror(element, this.getAnnotationName()).isPresent();
    }

    boolean hasAnyMemberAnnotation(ExecutableElement element) {
        return this.getMemberAnnotations().stream().map(name -> Mirrors.findAnnotationMirror((Element)element, name)).anyMatch(Optional::isPresent);
    }
}

