/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.Entity;
import io.requery.ForeignKey;
import io.requery.Key;
import io.requery.ReferentialAction;
import io.requery.Table;
import io.requery.com.squareup.javapoet.AnnotationSpec;
import io.requery.com.squareup.javapoet.ClassName;
import io.requery.com.squareup.javapoet.FieldSpec;
import io.requery.com.squareup.javapoet.TypeName;
import io.requery.com.squareup.javapoet.TypeSpec;
import io.requery.processor.AssociativeEntityDescriptor;
import io.requery.processor.AssociativeReference;
import io.requery.processor.AttributeDescriptor;
import io.requery.processor.CodeGeneration;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.EntityNameResolver;
import io.requery.processor.Names;
import io.requery.processor.SourceGenerator;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

class JoinEntityGenerator
implements SourceGenerator {
    private final ProcessingEnvironment processingEnvironment;
    private final EntityNameResolver nameResolver;
    private final EntityDescriptor from;
    private final EntityDescriptor to;
    private final AttributeDescriptor attribute;

    JoinEntityGenerator(ProcessingEnvironment processingEnvironment, EntityNameResolver nameResolver, EntityDescriptor from, EntityDescriptor to, AttributeDescriptor attribute) {
        this.processingEnvironment = processingEnvironment;
        this.nameResolver = nameResolver;
        this.from = from;
        this.to = to;
        this.attribute = attribute;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate() throws IOException {
        AssociativeEntityDescriptor descriptor = this.attribute.associativeEntity().orElseThrow(IllegalStateException::new);
        String name = descriptor.name();
        if (Names.isEmpty(name)) {
            name = this.from.tableName() + "_" + this.to.tableName();
        }
        ClassName entityName = this.nameResolver.joinEntityName(descriptor, this.from, this.to);
        String className = "Abstract" + entityName.simpleName();
        TypeSpec.Builder junctionType = TypeSpec.classBuilder(className).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).addSuperinterface((Type)((Object)Serializable.class)).addAnnotation(AnnotationSpec.builder(Entity.class).addMember("model", "$S", this.from.modelName()).addMember("stateless", "$L", this.from.isStateless()).build()).addAnnotation(AnnotationSpec.builder(Table.class).addMember("name", "$S", name).build());
        CodeGeneration.addGeneratedAnnotation(this.processingEnvironment, junctionType);
        Set<AssociativeReference> references = descriptor.columns();
        EntityDescriptor[] entities = new EntityDescriptor[]{this.from, this.to};
        LinkedHashMap<AssociativeReference, EntityDescriptor> map = new LinkedHashMap<AssociativeReference, EntityDescriptor>();
        if (references.isEmpty()) {
            for (int i = 0; i < entities.length; ++i) {
                void var11_16;
                EntityDescriptor entityDescriptor = entities[i];
                String string = entityDescriptor.tableName() + "Id";
                if (this.from == this.to) {
                    String string2 = string + (i + 1);
                }
                AssociativeReference reference = new AssociativeReference((String)var11_16, entityDescriptor.element(), null, ReferentialAction.CASCADE, ReferentialAction.CASCADE);
                references.add(reference);
                map.put(reference, entityDescriptor);
            }
        } else {
            for (AssociativeReference associativeReference : references) {
                for (EntityDescriptor entity : entities) {
                    if (associativeReference.referencedType() == null || !associativeReference.referencedType().equals(entity.element())) continue;
                    map.put(associativeReference, entity);
                }
            }
        }
        int index = 0;
        for (AssociativeReference associativeReference : references) {
            Optional<AttributeDescriptor> keyAttribute;
            ClassName action = ClassName.get(ReferentialAction.class);
            AnnotationSpec.Builder key = AnnotationSpec.builder(ForeignKey.class).addMember("delete", "$T.$L", action, associativeReference.deleteAction().toString()).addMember("update", "$T.$L", action, associativeReference.updateAction().toString());
            TypeElement referenceElement = associativeReference.referencedType();
            EntityDescriptor entity = (EntityDescriptor)map.get(associativeReference);
            if (referenceElement == null) {
                referenceElement = entity != null ? entity.element() : entities[index++].element();
            }
            if (referenceElement != null) {
                key.addMember("references", "$L.class", this.nameResolver.generatedTypeNameOf(referenceElement).orElseThrow(IllegalStateException::new));
            }
            if (associativeReference.referencedColumn() != null) {
                key.addMember("referencedColumn", "$S", associativeReference.referencedColumn());
            }
            AnnotationSpec.Builder id = AnnotationSpec.builder(Key.class);
            TypeName typeName = TypeName.get(Integer.class);
            if (entity != null && (keyAttribute = entity.attributes().stream().filter(AttributeDescriptor::isKey).findAny()).isPresent()) {
                TypeMirror keyType = keyAttribute.get().typeMirror();
                if (keyType.getKind().isPrimitive()) {
                    Types types = this.processingEnvironment.getTypeUtils();
                    keyType = types.boxedClass((PrimitiveType)keyType).asType();
                }
                typeName = TypeName.get(keyType);
            }
            FieldSpec.Builder field = FieldSpec.builder(typeName, associativeReference.name(), Modifier.PROTECTED).addAnnotation(key.build()).addAnnotation(id.build());
            junctionType.addField(field.build());
        }
        String string = entityName.packageName();
        CodeGeneration.writeType(this.processingEnvironment, string, junctionType.build());
    }
}

