/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

final class Mirrors {
    private Mirrors() {
    }

    static Optional<? extends AnnotationMirror> findAnnotationMirror(Element element, Class<? extends Annotation> annotation) {
        return Mirrors.findAnnotationMirror(element, annotation.getName());
    }

    static Optional<? extends AnnotationMirror> findAnnotationMirror(Element element, String qualifiedName) {
        return element.getAnnotationMirrors().stream().filter(mirror -> Mirrors.namesEqual((TypeElement)mirror.getAnnotationType().asElement(), qualifiedName)).findFirst();
    }

    static Optional<AnnotationValue> findAnnotationValue(AnnotationMirror mirror) {
        return Mirrors.findAnnotationValue(mirror, "value");
    }

    static Optional<AnnotationValue> findAnnotationValue(AnnotationMirror mirror, String name) {
        return mirror.getElementValues() == null ? Optional.empty() : mirror.getElementValues().entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().contentEquals(name)).map(entry -> (AnnotationValue)entry.getValue()).findFirst();
    }

    static List<TypeMirror> listGenericTypeArguments(TypeMirror typeMirror) {
        final ArrayList<TypeMirror> typeArguments = new ArrayList<TypeMirror>();
        typeMirror.accept(new SimpleTypeVisitor6<Void, Void>(){

            @Override
            public Void visitDeclared(DeclaredType declaredType, Void v) {
                if (!declaredType.getTypeArguments().isEmpty()) {
                    typeArguments.addAll(declaredType.getTypeArguments());
                }
                return null;
            }

            @Override
            protected Void defaultAction(TypeMirror typeMirror, Void v) {
                return null;
            }
        }, null);
        return typeArguments;
    }

    static boolean isInstance(Types types, TypeElement element, Class<?> type) {
        if (element == null) {
            return false;
        }
        String className = type.getCanonicalName();
        if (type.isInterface()) {
            return Mirrors.implementsInterface(types, element, className);
        }
        return Mirrors.namesEqual(element, className) || Mirrors.extendsClass(types, element, className);
    }

    static boolean isInstance(Types types, TypeElement element, String className) {
        if (element == null) {
            return false;
        }
        if (Mirrors.namesEqual(element, className)) {
            return true;
        }
        return Mirrors.implementsInterface(types, element, className) || Mirrors.extendsClass(types, element, className);
    }

    private static boolean implementsInterface(Types types, TypeElement element, String interfaceName) {
        TypeElement currentElement;
        if (Mirrors.namesEqual(element, interfaceName)) {
            return true;
        }
        TypeMirror type = element.asType();
        while (type != null && type.getKind() != TypeKind.NONE && (currentElement = (TypeElement)types.asElement(type)) != null) {
            List<? extends TypeMirror> interfaces = element.getInterfaces();
            for (TypeMirror typeMirror : interfaces) {
                TypeMirror typeMirror2 = types.erasure(typeMirror);
                TypeElement typeElement = (TypeElement)types.asElement(typeMirror2);
                if (typeElement == null || !Mirrors.implementsInterface(types, typeElement, interfaceName)) continue;
                return true;
            }
            type = currentElement.getSuperclass();
        }
        return false;
    }

    private static boolean extendsClass(Types types, TypeElement element, String className) {
        if (Mirrors.namesEqual(element, className)) {
            return true;
        }
        TypeMirror superType = element.getSuperclass();
        while (superType != null && superType.getKind() != TypeKind.NONE) {
            TypeElement superTypeElement = (TypeElement)types.asElement(superType);
            if (Mirrors.namesEqual(superTypeElement, className)) {
                return true;
            }
            superType = superTypeElement.getSuperclass();
        }
        return false;
    }

    static boolean overridesMethod(Types types, TypeElement element, String methodName) {
        while (element != null) {
            if (ElementFilter.methodsIn(element.getEnclosedElements()).stream().anyMatch(method -> method.getSimpleName().contentEquals(methodName))) {
                return true;
            }
            TypeMirror superType = element.getSuperclass();
            if (superType.getKind() != TypeKind.NONE && !Mirrors.namesEqual(element = (TypeElement)types.asElement(superType), Object.class.getCanonicalName())) continue;
            break;
        }
        return false;
    }

    private static boolean namesEqual(TypeElement element, String qualifiedName) {
        return element != null && element.getQualifiedName().contentEquals(qualifiedName);
    }
}

