/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import javax.lang.model.SourceVersion;

final class Names {
    private Names() {
    }

    public static boolean isEmpty(CharSequence name) {
        return name == null || name.toString().isEmpty();
    }

    public static String lowerCaseFirst(CharSequence name) {
        StringBuilder sb = new StringBuilder(name);
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        return sb.toString();
    }

    public static String upperCaseFirst(CharSequence name) {
        StringBuilder sb = new StringBuilder(name);
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        return sb.toString();
    }

    public static String upperCaseUnderscore(CharSequence name) {
        StringBuilder sb = new StringBuilder(name);
        boolean wasLower = false;
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (Character.isUpperCase(c) && wasLower) {
                sb.insert(i, "_");
                wasLower = false;
                continue;
            }
            wasLower = Character.isLowerCase(c);
        }
        return sb.toString().toUpperCase();
    }

    public static boolean isAllUpper(CharSequence name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public static String removeMemberPrefixes(CharSequence name) {
        String string = name.toString();
        if (string.startsWith("_")) {
            return string.substring(1);
        }
        if (string.length() > 1 && string.startsWith("m") && Character.isUpperCase(string.charAt(1))) {
            return string.substring(1);
        }
        return string;
    }

    public static String removeMethodPrefixes(CharSequence name) {
        String string = name.toString();
        if (string.startsWith("get") || string.startsWith("set")) {
            return string.substring(3);
        }
        if (string.startsWith("is") && string.length() > 2 && Character.isUpperCase(string.charAt(2))) {
            return string.substring(2);
        }
        return string;
    }

    public static String removeClassPrefixes(CharSequence name) {
        String typeName = name.toString();
        if (typeName.startsWith("Abstract")) {
            return typeName.replaceFirst("Abstract", "");
        }
        if (typeName.startsWith("Base")) {
            return typeName.replaceFirst("Base", "");
        }
        return typeName;
    }

    public static String checkReservedName(CharSequence name, CharSequence fallback) {
        return SourceVersion.isName(name) ? name.toString() : fallback.toString();
    }

    static boolean matchesSetter(String prefix, String name) {
        return name.startsWith(prefix) && name.length() > prefix.length() && Character.isUpperCase(name.charAt(prefix.length()));
    }
}

