/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.examples.springmvc.controller;

import io.restassured.examples.springmvc.controller.support.Greeting;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UserAwareController {
    private static final String template = "Hello, %s!";
    private final AtomicLong counter = new AtomicLong();

    @RequestMapping(value={"/user/greeting"}, method={RequestMethod.GET})
    @ResponseBody
    public Greeting greeting(@RequestParam(value="name", required=false, defaultValue="World") String name, @AuthenticationPrincipal User user) {
        if (user == null || !user.getUsername().equals("authorized_user")) {
            throw new IllegalArgumentException("Not authorized");
        }
        return new Greeting(this.counter.incrementAndGet(), String.format(template, name));
    }
}

