/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.webtestclient.specification;

import io.restassured.config.LogConfig;
import io.restassured.filter.log.LogDetail;
import io.restassured.filter.log.RequestLoggingFilter;
import io.restassured.http.ContentType;
import io.restassured.http.Cookie;
import io.restassured.http.Header;
import io.restassured.internal.assertion.AssertParameter;
import io.restassured.mapper.ObjectMapper;
import io.restassured.mapper.ObjectMapperType;
import io.restassured.module.webtestclient.RestAssuredWebTestClient;
import io.restassured.module.webtestclient.config.RestAssuredWebTestClientConfig;
import io.restassured.module.webtestclient.internal.WebTestClientFactory;
import io.restassured.module.webtestclient.internal.WebTestClientRequestSpecificationImpl;
import io.restassured.module.webtestclient.specification.WebTestClientRequestSpecification;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WebTestClientConfigurer;
import org.springframework.web.context.WebApplicationContext;

public class WebTestClientRequestSpecBuilder {
    private WebTestClientRequestSpecificationImpl spec = new WebTestClientRequestSpecificationImpl(WebTestClientRequestSpecBuilder.getConfiguredWebTestClientFactory(), RestAssuredWebTestClient.config, RestAssuredWebTestClient.basePath, RestAssuredWebTestClient.requestSpecification, RestAssuredWebTestClient.responseSpecification);

    private static WebTestClientFactory getConfiguredWebTestClientFactory() {
        try {
            Field WebTestClientFactory2 = RestAssuredWebTestClient.class.getDeclaredField("webTestClientFactory");
            WebTestClientFactory2.setAccessible(true);
            Object instance = WebTestClientFactory2.get(RestAssuredWebTestClient.class);
            WebTestClientFactory2.setAccessible(false);
            return (WebTestClientFactory)instance;
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error: Cannot find WebTestClientFactory field in " + RestAssuredWebTestClient.class.getName());
        }
    }

    public WebTestClientRequestSpecBuilder setBody(String body) {
        this.spec.body(body);
        return this;
    }

    public WebTestClientRequestSpecBuilder setBody(byte[] body) {
        this.spec.body(body);
        return this;
    }

    public WebTestClientRequestSpecBuilder setBody(Object object) {
        this.spec.body(object);
        return this;
    }

    public WebTestClientRequestSpecBuilder setBody(Object object, ObjectMapper mapper) {
        this.spec.body(object, mapper);
        return this;
    }

    public WebTestClientRequestSpecBuilder setBody(Object object, ObjectMapperType mapperType) {
        this.spec.body(object, mapperType);
        return this;
    }

    public WebTestClientRequestSpecBuilder addCookies(Map<String, ?> cookies) {
        this.spec.cookies(cookies);
        return this;
    }

    public WebTestClientRequestSpecBuilder addCookie(Cookie cookie) {
        this.spec.cookie(cookie);
        return this;
    }

    public WebTestClientRequestSpecBuilder addCookie(String key, Object value, Object ... cookieNameValuePairs) {
        this.spec.cookie(key, value, cookieNameValuePairs);
        return this;
    }

    public WebTestClientRequestSpecBuilder addParams(Map<String, ?> parametersMap) {
        this.spec.params(parametersMap);
        return this;
    }

    public WebTestClientRequestSpecBuilder addParam(String parameterName, Object ... parameterValues) {
        this.spec.param(parameterName, parameterValues);
        return this;
    }

    public WebTestClientRequestSpecBuilder addParam(String parameterName, Collection<?> parameterValues) {
        this.spec.param(parameterName, parameterValues);
        return this;
    }

    public WebTestClientRequestSpecBuilder addQueryParam(String parameterName, Collection<?> parameterValues) {
        this.spec.queryParam(parameterName, parameterValues);
        return this;
    }

    public WebTestClientRequestSpecBuilder addQueryParams(Map<String, ?> parametersMap) {
        this.spec.queryParams(parametersMap);
        return this;
    }

    public WebTestClientRequestSpecBuilder addQueryParam(String parameterName, Object ... parameterValues) {
        this.spec.queryParam(parameterName, parameterValues);
        return this;
    }

    public WebTestClientRequestSpecBuilder addFormParam(String parameterName, Collection<?> parameterValues) {
        this.spec.formParam(parameterName, parameterValues);
        return this;
    }

    public WebTestClientRequestSpecBuilder addFormParams(Map<String, ?> parametersMap) {
        this.spec.formParams(parametersMap);
        return this;
    }

    public WebTestClientRequestSpecBuilder addFormParam(String parameterName, Object ... parameterValues) {
        this.spec.formParam(parameterName, parameterValues);
        return this;
    }

    public WebTestClientRequestSpecBuilder addAttribute(String attributeName, Object attributeValue) {
        this.spec.attribute(attributeName, attributeValue);
        return this;
    }

    public WebTestClientRequestSpecBuilder addAttributes(Map<String, ?> attributesMap) {
        this.spec.attributes(attributesMap);
        return this;
    }

    public WebTestClientRequestSpecBuilder addHeaders(Map<String, String> headers) {
        this.spec.headers(headers);
        return this;
    }

    public WebTestClientRequestSpecBuilder addHeader(String headerName, String headerValue) {
        this.spec.header(headerName, headerValue, new Object[0]);
        return this;
    }

    public WebTestClientRequestSpecBuilder addHeader(Header header) {
        this.spec.header(header);
        return this;
    }

    public WebTestClientRequestSpecBuilder setContentType(ContentType contentType) {
        this.spec.contentType(contentType);
        return this;
    }

    public WebTestClientRequestSpecBuilder setContentType(String contentType) {
        this.spec.contentType(contentType);
        return this;
    }

    public WebTestClientRequestSpecBuilder addMultiPart(File file) {
        this.spec.multiPart(file);
        return this;
    }

    public WebTestClientRequestSpecBuilder addMultiPart(String controlName, File file) {
        this.spec.multiPart(controlName, file);
        return this;
    }

    public WebTestClientRequestSpecBuilder addMultiPart(String controlName, File file, String mimeType) {
        this.spec.multiPart(controlName, file, mimeType);
        return this;
    }

    public WebTestClientRequestSpecBuilder addMultiPart(String controlName, String fileName, byte[] bytes) {
        this.spec.multiPart(controlName, fileName, bytes);
        return this;
    }

    public WebTestClientRequestSpecBuilder addMultiPart(String controlName, String fileName, byte[] bytes, String mimeType) {
        this.spec.multiPart(controlName, fileName, bytes, mimeType);
        return this;
    }

    public WebTestClientRequestSpecBuilder addMultiPart(String controlName, String fileName, InputStream stream) {
        this.spec.multiPart(controlName, fileName, stream);
        return this;
    }

    public WebTestClientRequestSpecBuilder addMultiPart(String controlName, String fileName, InputStream stream, String mimeType) {
        this.spec.multiPart(controlName, fileName, stream, mimeType);
        return this;
    }

    public WebTestClientRequestSpecBuilder addMultiPart(String controlName, String contentBody) {
        this.spec.multiPart(controlName, contentBody);
        return this;
    }

    public WebTestClientRequestSpecBuilder addMultiPart(String controlName, String contentBody, String mimeType) {
        this.spec.multiPart(controlName, mimeType);
        return this;
    }

    public WebTestClientRequestSpecBuilder setSessionId(String sessionIdValue) {
        this.spec.sessionId(sessionIdValue);
        return this;
    }

    public WebTestClientRequestSpecBuilder setSessionId(String sessionIdName, String sessionIdValue) {
        this.spec.sessionId(sessionIdName, sessionIdValue);
        return this;
    }

    public WebTestClientRequestSpecBuilder addWebTestClientRequestSpecification(WebTestClientRequestSpecification specification) {
        this.spec.spec(specification);
        return this;
    }

    public WebTestClientRequestSpecBuilder setConfig(RestAssuredWebTestClientConfig config) {
        this.spec.config(config);
        return this;
    }

    public WebTestClientRequestSpecification build() {
        return this.spec;
    }

    public WebTestClientRequestSpecBuilder setBasePath(String basePath) {
        this.spec.basePath(basePath);
        return this;
    }

    public WebTestClientRequestSpecBuilder setWebTestClient(WebTestClient webTestClient) {
        this.spec.webTestClient(webTestClient);
        return this;
    }

    public WebTestClientRequestSpecBuilder setStandaloneSetup(Object ... controllers) {
        this.spec.standaloneSetup(controllers);
        return this;
    }

    public WebTestClientRequestSpecBuilder setStandaloneSetup(WebTestClient.Builder builder) {
        this.spec.standaloneSetup(builder);
        return this;
    }

    public WebTestClientRequestSpecBuilder setWebAppContextSetup(WebApplicationContext context, WebTestClientConfigurer ... WebTestClientConfigurers) {
        this.spec.webAppContextSetup(context, WebTestClientConfigurers);
        return this;
    }

    public WebTestClientRequestSpecBuilder log(LogDetail logDetail) {
        AssertParameter.notNull((Object)logDetail, LogDetail.class);
        LogConfig logConfig = this.spec.getRestAssuredWebTestClientConfig().getLogConfig();
        PrintStream printStream = logConfig.defaultStream();
        boolean prettyPrintingEnabled = logConfig.isPrettyPrintingEnabled();
        boolean shouldUrlEncodeRequestUri = logConfig.shouldUrlEncodeRequestUri();
        this.spec.setRequestLoggingFilter(new RequestLoggingFilter(logDetail, prettyPrintingEnabled, printStream, shouldUrlEncodeRequestUri));
        return this;
    }

    public WebTestClientRequestSpecBuilder and() {
        return this;
    }
}

