package restx.admin;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.admin.AdminModule;


@Machine
public class AdminModuleFactoryMachine extends DefaultFactoryMachine {
    private static final AdminModule module = new AdminModule();

    public AdminModuleFactoryMachine() {
        super(10000, new MachineEngine[] {
            new StdMachineEngine<java.lang.String>(Name.of(java.lang.String.class, "restx.admin.password"), 10000, BoundlessComponentBox.FACTORY) {
        
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        
                    ));
                }

                @Override
                public java.lang.String doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.restxAdminPassword(
	        
	                    );
                }
            },
            new StdMachineEngine<java.lang.String>(Name.of(java.lang.String.class, "restx.admin.passwordHash"), 10000, BoundlessComponentBox.FACTORY) {
        private final Factory.Query<java.lang.String> password = Factory.Query.byName(Name.of(java.lang.String.class, "restx.admin.password")).mandatory();
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        password
                    ));
                }

                @Override
                public java.lang.String doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.restxAdminPasswordHash(
	        satisfiedBOM.getOne(password).get().getComponent()
	                    );
                }
            },
            new StdMachineEngine<restx.security.BasicPrincipalAuthenticator>(Name.of(restx.security.BasicPrincipalAuthenticator.class, "basicPrincipalAuthenticator"), 10000, BoundlessComponentBox.FACTORY) {
        private final Factory.Query<java.lang.String> adminPasswordHash = Factory.Query.byName(Name.of(java.lang.String.class, "restx.admin.passwordHash")).mandatory();
private final Factory.Query<restx.security.SecuritySettings> securitySettings = Factory.Query.byClass(restx.security.SecuritySettings.class).mandatory();
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        adminPasswordHash,
securitySettings
                    ));
                }

                @Override
                public restx.security.BasicPrincipalAuthenticator doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.basicPrincipalAuthenticator(
	        satisfiedBOM.getOne(adminPasswordHash).get().getComponent(),
satisfiedBOM.getOne(securitySettings).get().getComponent()
	                    );
                }
            },
            new StdMachineEngine<restx.RestxFilter>(Name.of(restx.RestxFilter.class, "adminRoleFilter"), 10000, BoundlessComponentBox.FACTORY) {
        private final Factory.Query<restx.security.PermissionFactory> permissionFactory = Factory.Query.byClass(restx.security.PermissionFactory.class).mandatory();
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        permissionFactory
                    ));
                }

                @Override
                public restx.RestxFilter doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.adminRoleFilter(
	        satisfiedBOM.getOne(permissionFactory).get().getComponent()
	                    );
                }
            },

        });
    }
}
