package restx.admin;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.admin.AdminPagesResource;

@Machine
public class AdminPagesResourceFactoryMachine extends SingleNameFactoryMachine<restx.admin.AdminPagesResource> {
    public static final Name<restx.admin.AdminPagesResource> NAME = Name.of(restx.admin.AdminPagesResource.class, "AdminPagesResource");

    public AdminPagesResourceFactoryMachine() {
        super(0, new StdMachineEngine<restx.admin.AdminPagesResource>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.admin.AdminPage> pages = Factory.Query.byClass(restx.admin.AdminPage.class).optional();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
pages
                ));
            }

            @Override
            protected restx.admin.AdminPagesResource doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new AdminPagesResource(
satisfiedBOM.getAsComponents(pages)
                );
            }
        });
    }

}
