package restx.admin;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.admin.SourcesModule;


@Machine
public class SourcesModuleFactoryMachine extends DefaultFactoryMachine {
    private static final SourcesModule module = new SourcesModule();

    public SourcesModuleFactoryMachine() {
        super(0, new MachineEngine[] {
            new StdMachineEngine<restx.admin.AdminPage>(Name.of(restx.admin.AdminPage.class, "Sources"), 0, BoundlessComponentBox.FACTORY) {
        
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        
                    ));
                }

                @Override
                public restx.admin.AdminPage doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.getSourcesAdminPage(
	        
	                    );
                }
            },
            new StdMachineEngine<restx.ResourcesRoute>(Name.of(restx.ResourcesRoute.class, "sourceUI"), 0, BoundlessComponentBox.FACTORY) {
        
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        
                    ));
                }

                @Override
                public restx.ResourcesRoute doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.sourceUI(
	        
	                    );
                }
            },
            new StdMachineEngine<restx.RestxRouter>(Name.of(restx.RestxRouter.class, "mountSources"), 0, BoundlessComponentBox.FACTORY) {
        private final Factory.Query<restx.AppSettings> appSettings = Factory.Query.byClass(restx.AppSettings.class).mandatory();
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        appSettings
                    ));
                }

                @Override
                public restx.RestxRouter doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.mountSources(
	        satisfiedBOM.getOne(appSettings).get().getComponent()
	                    );
                }
            },
            new StdMachineEngine<restx.RestxRouter>(Name.of(restx.RestxRouter.class, "mountResources"), 0, BoundlessComponentBox.FACTORY) {
        private final Factory.Query<restx.AppSettings> appSettings = Factory.Query.byClass(restx.AppSettings.class).mandatory();
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        appSettings
                    ));
                }

                @Override
                public restx.RestxRouter doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.mountResources(
	        satisfiedBOM.getOne(appSettings).get().getComponent()
	                    );
                }
            },

        });
    }
}
