package restx.config;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.config.ConfigResource;

@Machine
public class ConfigResourceFactoryMachine extends SingleNameFactoryMachine<restx.config.ConfigResource> {
    public static final Name<restx.config.ConfigResource> NAME = Name.of(restx.config.ConfigResource.class, "ConfigResource");

    public ConfigResourceFactoryMachine() {
        super(0, new StdMachineEngine<restx.config.ConfigResource>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.common.RestxConfig> config = Factory.Query.byClass(restx.common.RestxConfig.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
config
                ));
            }

            @Override
            protected restx.config.ConfigResource doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new ConfigResource(
satisfiedBOM.getOne(config).get().getComponent()
                );
            }
        });
    }

}
