package restx.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Optional;
import com.google.common.base.Suppliers;
import static com.google.common.base.Preconditions.checkNotNull;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableList;
import restx.common.Types;
import restx.common.TypeReference;
import restx.*;
import restx.entity.*;
import restx.http.*;
import restx.endpoint.*;
import restx.exceptions.WrappedCheckedException;
import restx.factory.*;
import restx.security.*;
import restx.security.PermissionFactory;
import restx.description.*;
import restx.converters.MainStringConverter;
import static restx.common.MorePreconditions.checkPresent;

import javax.validation.Validator;
import static restx.validation.Validations.checkValid;

import java.io.IOException;
import java.io.PrintWriter;

import java.util.Arrays;


@Component(priority = 0)

public class ConfigResourceRouter extends RestxRouter {

    public ConfigResourceRouter(
                    final ConfigResource resource,
                    final EntityRequestBodyReaderRegistry readerRegistry,
                    final EntityResponseWriterRegistry writerRegistry,
                    final MainStringConverter converter,
                    final PermissionFactory pf,
                    final Optional<Validator> validator,
                    final RestxSecurityManager securityManager,
                    final EndpointParameterMapperRegistry paramMapperRegistry) {
        super(
            "restx-admin", "ConfigResourceRouter", new RestxRoute[] {
        new StdEntityRoute<Void, java.lang.Iterable<restx.common.ConfigElement>>("restx-admin#ConfigResource#findConfigElements",
                readerRegistry.<Void>build(Void.class, Optional.<String>absent()),
                writerRegistry.<java.lang.Iterable<restx.common.ConfigElement>>build(Types.newParameterizedType(java.lang.Iterable.class, restx.common.ConfigElement.class), Optional.<String>absent()),
                Endpoint.of("GET", "/@/config/elements"),
                HttpStatus.OK, RestxLogLevel.DEFAULT, pf,
                paramMapperRegistry, new ParamDef[]{

                }) {
            @Override
            protected Optional<java.lang.Iterable<restx.common.ConfigElement>> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, hasRole("restx-admin"));
                try {
                    return Optional.of(resource.findConfigElements(
                        
                    ));
                } catch(RuntimeException e) { throw e; }
                  catch(Exception e) { throw new WrappedCheckedException(e); }
            }

            @Override
            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);


                operation.responseClass = "LIST[ConfigElement]";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "restx.common.ConfigElement";
                operation.outEntityType = Types.newParameterizedType(java.lang.Iterable.class, restx.common.ConfigElement.class);
                operation.sourceLocation = "restx.config.ConfigResource#findConfigElements()";
                operation.annotations = ImmutableList.<java.lang.annotation.Annotation>builder()
                    .add(new restx.security.RolesAllowed() {
                        public Class<restx.security.RolesAllowed> annotationType() { return restx.security.RolesAllowed.class; }
                        public java.lang.String[] value() { return new java.lang.String[]{ "restx-admin" }; }
                    })
                    .add(new restx.annotations.GET() {
                        public Class<restx.annotations.GET> annotationType() { return restx.annotations.GET.class; }
                        public java.lang.String value() { return "/@/config/elements"; }
                    })
                    .build();
            }
        },
        });
    }

}
