package restx.config;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.config.ConfigResourceRouter;

@Machine
public class ConfigResourceRouterFactoryMachine extends SingleNameFactoryMachine<restx.config.ConfigResourceRouter> {
    public static final Name<restx.config.ConfigResourceRouter> NAME = Name.of(restx.config.ConfigResourceRouter.class, "ConfigResourceRouter");

    public ConfigResourceRouterFactoryMachine() {
        super(0, new StdMachineEngine<restx.config.ConfigResourceRouter>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.config.ConfigResource> resource = Factory.Query.byClass(restx.config.ConfigResource.class).mandatory();
private final Factory.Query<restx.entity.EntityRequestBodyReaderRegistry> readerRegistry = Factory.Query.byClass(restx.entity.EntityRequestBodyReaderRegistry.class).mandatory();
private final Factory.Query<restx.entity.EntityResponseWriterRegistry> writerRegistry = Factory.Query.byClass(restx.entity.EntityResponseWriterRegistry.class).mandatory();
private final Factory.Query<restx.converters.MainStringConverter> converter = Factory.Query.byClass(restx.converters.MainStringConverter.class).mandatory();
private final Factory.Query<restx.security.PermissionFactory> pf = Factory.Query.byClass(restx.security.PermissionFactory.class).mandatory();
private final Factory.Query<javax.validation.Validator> validator = Factory.Query.byClass(javax.validation.Validator.class).optional();
private final Factory.Query<restx.security.RestxSecurityManager> securityManager = Factory.Query.byClass(restx.security.RestxSecurityManager.class).mandatory();
private final Factory.Query<restx.endpoint.EndpointParameterMapperRegistry> paramMapperRegistry = Factory.Query.byClass(restx.endpoint.EndpointParameterMapperRegistry.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
resource,
readerRegistry,
writerRegistry,
converter,
pf,
validator,
securityManager,
paramMapperRegistry
                ));
            }

            @Override
            protected restx.config.ConfigResourceRouter doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new ConfigResourceRouter(
satisfiedBOM.getOne(resource).get().getComponent(),
satisfiedBOM.getOne(readerRegistry).get().getComponent(),
satisfiedBOM.getOne(writerRegistry).get().getComponent(),
satisfiedBOM.getOne(converter).get().getComponent(),
satisfiedBOM.getOne(pf).get().getComponent(),
satisfiedBOM.getOneAsComponent(validator),
satisfiedBOM.getOne(securityManager).get().getComponent(),
satisfiedBOM.getOne(paramMapperRegistry).get().getComponent()
                );
            }
        });
    }

}
