package restx.exceptions;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.exceptions.ErrorDescriptorsRoute;

@Machine
public class ErrorDescriptorsRouteFactoryMachine extends SingleNameFactoryMachine<restx.exceptions.ErrorDescriptorsRoute> {
    public static final Name<restx.exceptions.ErrorDescriptorsRoute> NAME = Name.of(restx.exceptions.ErrorDescriptorsRoute.class, "ErrorDescriptorsRoute");

    public ErrorDescriptorsRouteFactoryMachine() {
        super(0, new StdMachineEngine<restx.exceptions.ErrorDescriptorsRoute>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.exceptions.ErrorDescriptor> errorDescriptors = Factory.Query.byClass(restx.exceptions.ErrorDescriptor.class).optional();
private final Factory.Query<com.fasterxml.jackson.databind.ObjectWriter> objectWriter = Factory.Query.byName(Name.of(com.fasterxml.jackson.databind.ObjectWriter.class, "FrontObjectWriter")).mandatory();
private final Factory.Query<restx.security.RestxSecurityManager> securityManager = Factory.Query.byClass(restx.security.RestxSecurityManager.class).mandatory();
private final Factory.Query<restx.security.PermissionFactory> permissionFactory = Factory.Query.byClass(restx.security.PermissionFactory.class).mandatory();
private final Factory.Query<restx.endpoint.EndpointParameterMapperRegistry> registry = Factory.Query.byClass(restx.endpoint.EndpointParameterMapperRegistry.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
errorDescriptors,
objectWriter,
securityManager,
permissionFactory,
registry
                ));
            }

            @Override
            protected restx.exceptions.ErrorDescriptorsRoute doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new ErrorDescriptorsRoute(
satisfiedBOM.getAsComponents(errorDescriptors),
satisfiedBOM.getOne(objectWriter).get().getComponent(),
satisfiedBOM.getOne(securityManager).get().getComponent(),
satisfiedBOM.getOne(permissionFactory).get().getComponent(),
satisfiedBOM.getOne(registry).get().getComponent()
                );
            }
        });
    }

}
