/*
 * Decompiled with CFR 0.152.
 */
package restx.config;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.validation.Validator;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.annotations.GET;
import restx.common.ConfigElement;
import restx.common.Types;
import restx.config.ConfigResource;
import restx.converters.MainStringConverter;
import restx.description.OperationDescription;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.entity.EntityRequestBodyReaderRegistry;
import restx.entity.EntityResponseWriterRegistry;
import restx.entity.StdEntityRoute;
import restx.exceptions.WrappedCheckedException;
import restx.factory.Component;
import restx.factory.ParamDef;
import restx.http.HttpStatus;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;
import restx.security.RolesAllowed;

@Component(priority=0)
public class ConfigResourceRouter
extends RestxRouter {
    public ConfigResourceRouter(final ConfigResource resource, EntityRequestBodyReaderRegistry readerRegistry, EntityResponseWriterRegistry writerRegistry, MainStringConverter converter, PermissionFactory pf, Optional<Validator> validator, final RestxSecurityManager securityManager, EndpointParameterMapperRegistry paramMapperRegistry) {
        super("restx-admin", "ConfigResourceRouter", new RestxRoute[]{new StdEntityRoute<Void, Iterable<ConfigElement>>("restx-admin#ConfigResource#findConfigElements", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build((Type)Types.newParameterizedType(Iterable.class, (Type[])new Type[]{ConfigElement.class}), Optional.absent()), Endpoint.of((String)"GET", (String)"/@/config/elements"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[0]){

            protected Optional<Iterable<ConfigElement>> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of(resource.findConfigElements());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                operation.responseClass = "LIST[ConfigElement]";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "restx.common.ConfigElement";
                operation.outEntityType = Types.newParameterizedType(Iterable.class, (Type[])new Type[]{ConfigElement.class});
                operation.sourceLocation = "restx.config.ConfigResource#findConfigElements()";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/config/elements";
                    }
                }).build();
            }
        }});
    }
}

