/*
 * Decompiled with CFR 0.152.
 */
package restx.apidocs.doclet;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.io.Files;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.standard.Standard;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.joda.time.DateTime;
import restx.apidocs.doclet.ApiEntryNotes;
import restx.apidocs.doclet.ApiOperationNotes;
import restx.apidocs.doclet.ApiParameterNotes;

public class ApidocsDoclet
extends Doclet {
    public static boolean start(RootDoc rootDoc) {
        Path targetDir = Paths.get((String)Options.TARGET_DIR.getOption(rootDoc.options()).or((Object)""), new String[0]);
        rootDoc.printNotice("generating RESTX apidocs notes in: " + targetDir + " ...");
        Path apidocsTarget = targetDir.resolve("apidocs");
        if (!apidocsTarget.toFile().exists()) {
            apidocsTarget.toFile().mkdirs();
        }
        Trace trace = Options.ENABLE_TRACE.isSet(rootDoc.options()) ? new FileTrace(targetDir.resolve("apidoclet.trace").toFile()) : new NoTrace();
        trace.trace("RESTX APIDOCLET " + DateTime.now());
        trace.trace("target dir : " + targetDir.toAbsolutePath());
        trace.trace("current dir: " + Paths.get("", new String[0]).toAbsolutePath());
        ObjectMapper mapper = new ObjectMapper();
        for (ClassDoc classDoc : rootDoc.classes()) {
            ApiEntryNotes entryNotes = new ApiEntryNotes().setName(classDoc.qualifiedName());
            for (MethodDoc methodDoc : classDoc.methods()) {
                for (AnnotationDesc annotationDesc : methodDoc.annotations()) {
                    Optional<Object> value;
                    if (!annotationDesc.annotationType().qualifiedName().startsWith("restx.annotations.") || !(value = ApidocsDoclet.getAnnotationParamValue(annotationDesc.elementValues(), "value")).isPresent()) continue;
                    trace.trace(classDoc.name() + " > " + methodDoc.qualifiedName() + " > " + annotationDesc.annotationType().name());
                    trace.trace(Arrays.asList(annotationDesc.elementValues()).toString());
                    trace.trace(methodDoc.commentText());
                    ApiOperationNotes operation = new ApiOperationNotes().setHttpMethod(annotationDesc.annotationType().name()).setPath(String.valueOf(value.get())).setNotes(methodDoc.commentText());
                    for (ParamTag paramTag : methodDoc.paramTags()) {
                        trace.trace("\t" + paramTag.parameterName() + " > " + paramTag.parameterComment());
                        operation.getParameters().add(new ApiParameterNotes().setName(paramTag.parameterName()).setNotes(paramTag.parameterComment()));
                    }
                    for (ParamTag paramTag : methodDoc.tags("return")) {
                        trace.trace("\t" + paramTag.name() + " > " + paramTag.text());
                        operation.getParameters().add(new ApiParameterNotes().setName("response").setNotes(paramTag.text()));
                    }
                    entryNotes.getOperations().add(operation);
                }
            }
            if (!entryNotes.getOperations().isEmpty()) {
                Path doc = apidocsTarget.resolve(classDoc.qualifiedName() + ".notes.json");
                rootDoc.printNotice("generating RESTX API entry notes for " + classDoc.qualifiedName() + " ...");
                trace.trace("generating notes in " + doc.toAbsolutePath());
                try {
                    mapper.writeValue(doc.toFile(), (Object)entryNotes);
                }
                catch (IOException e) {
                    trace.trace("can't write to api doc file " + doc.toFile() + ": " + e);
                    rootDoc.printError("can't write to api doc file " + doc.toFile() + ": " + e);
                }
                continue;
            }
            trace.trace("no operations found on " + entryNotes.getName());
        }
        if (Options.DISABLE_STANDARD_DOCLET.isSet(rootDoc.options())) {
            return true;
        }
        return Standard.start((RootDoc)rootDoc);
    }

    private static Optional<Object> getAnnotationParamValue(AnnotationDesc.ElementValuePair[] elementValuePairs, String paramName) {
        for (AnnotationDesc.ElementValuePair pair : elementValuePairs) {
            if (!pair.element().name().equals(paramName)) continue;
            return Optional.of((Object)pair.value().value());
        }
        return Optional.absent();
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static int optionLength(String option) {
        for (Options opt : Options.values()) {
            if (!opt.getOptionName().equalsIgnoreCase(option)) continue;
            return opt.getOptionLength();
        }
        return Standard.optionLength((String)option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter errorReporter) {
        return Standard.validOptions((String[][])options, (DocErrorReporter)errorReporter);
    }

    private static class NoTrace
    implements Trace {
        private NoTrace() {
        }

        @Override
        public void trace(String msg) {
        }
    }

    private static class FileTrace
    implements Trace {
        private final File traceFile;

        private FileTrace(File traceFile) {
            this.traceFile = traceFile;
        }

        @Override
        public void trace(String msg) {
            try {
                Files.append((CharSequence)(msg + "\n"), (File)this.traceFile, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface Trace {
        public void trace(String var1);
    }

    static enum Options {
        DISABLE_STANDARD_DOCLET("-disable-standard-doclet", 1),
        TARGET_DIR("-restx-target-dir", 2),
        ENABLE_TRACE("-restx-enable-trace", 1);

        private final String optionName;
        private final int optionLength;

        private Options(String name, int optionLength) {
            this.optionName = name;
            this.optionLength = optionLength;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public int getOptionLength() {
            return this.optionLength;
        }

        public boolean isSet(String[][] options) {
            for (String[] option : options) {
                if (options.length <= 0 || !this.optionName.equals(option[0])) continue;
                return true;
            }
            return false;
        }

        public Optional<String> getOption(String[][] options) {
            for (String[] option : options) {
                if (options.length <= 1 || !this.optionName.equals(option[0])) continue;
                return Optional.of((Object)option[1]);
            }
            return Optional.absent();
        }
    }
}

