/*
 * Decompiled with CFR 0.152.
 */
package restx.apidocs;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.CaseFormat;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRouter;
import restx.apidocs.ApiDeclarationRoute;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.factory.Component;
import restx.factory.Factory;
import restx.factory.NamedComponent;
import restx.jackson.StdJsonProducerEntityRoute;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;

@Component
public class ApiDocsIndexRoute
extends StdJsonProducerEntityRoute {
    private final Factory factory;
    private final RestxSecurityManager securityManager;

    @Inject
    public ApiDocsIndexRoute(@Named(value="FrontObjectWriter") ObjectWriter writer, Factory factory, RestxSecurityManager securityManager, PermissionFactory permissionFactory, EndpointParameterMapperRegistry registry) {
        super("ApiDocsIndexRoute", Map.class, writer, Endpoint.of((String)"GET", (String)"/@/api-docs"), permissionFactory, registry);
        this.factory = factory;
        this.securityManager = securityManager;
    }

    protected Optional<?> doRoute(RestxRequest restxRequest, RestxResponse response, RestxRequestMatch match, Object i) throws IOException {
        this.securityManager.check(restxRequest, match, this.hasRole("restx-admin"));
        return Optional.of((Object)ImmutableMap.builder().put((Object)"apiVersion", (Object)"0.1").put((Object)"swaggerVersion", (Object)"1.1").put((Object)"basePath", (Object)restxRequest.getBaseNetworkPath()).put((Object)"apis", this.buildApis()).build());
    }

    private List<ImmutableMap<String, String>> buildApis() {
        Set routers = this.factory.queryByClass(RestxRouter.class).find();
        ArrayList apis = Lists.newArrayList();
        for (NamedComponent router : routers) {
            String routerApiPath = ApiDocsIndexRoute.getRouterApiPath(router.getName().getName());
            if (!ApiDeclarationRoute.getRouterByName(this.factory, routerApiPath).isPresent()) continue;
            apis.add(ImmutableMap.of((Object)"path", (Object)("/@/api-docs/" + routerApiPath), (Object)"name", (Object)routerApiPath, (Object)"group", (Object)((RestxRouter)router.getComponent()).getGroupName(), (Object)"description", (Object)""));
        }
        return apis;
    }

    static String getRouterApiPath(String path) {
        path = path.replaceAll("Router$", "").replaceAll("Resource$", "");
        path = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, path);
        return path;
    }
}

