/*
 * Decompiled with CFR 0.152.
 */
package restx.apidocs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import javax.inject.Named;
import restx.WebException;
import restx.annotations.GET;
import restx.annotations.RestxResource;
import restx.factory.Component;
import restx.http.HttpStatus;
import restx.security.RolesAllowed;

@RestxResource(group="restx-admin")
@Component
public class JsonSchemaResource {
    private final ObjectMapper mapper;

    public JsonSchemaResource(@Named(value="FrontObjectMapper") ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @GET(value="/@/api-docs/schemas/{fqcn}")
    @RolesAllowed(value={"restx-admin"})
    public String getJsonSchema(String fqcn) {
        SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
        try {
            this.mapper.acceptJsonFormatVisitor(this.mapper.constructType(Class.forName(fqcn)), (JsonFormatVisitorWrapper)visitor);
        }
        catch (JsonMappingException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new WebException(HttpStatus.NOT_FOUND);
        }
        try {
            return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)visitor.finalSchema());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

