/*
 * Decompiled with CFR 0.152.
 */
package restx.apidocs;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import javax.validation.Validator;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.annotations.GET;
import restx.apidocs.JsonSchemaResource;
import restx.common.TypeReference;
import restx.converters.MainStringConverter;
import restx.description.OperationDescription;
import restx.description.OperationParameterDescription;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParameterKind;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.entity.EntityRequestBodyReaderRegistry;
import restx.entity.EntityResponseWriterRegistry;
import restx.entity.StdEntityRoute;
import restx.exceptions.WrappedCheckedException;
import restx.factory.Component;
import restx.factory.ParamDef;
import restx.http.HttpStatus;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;
import restx.security.RolesAllowed;
import restx.validation.Validations;

@Component(priority=0)
public class JsonSchemaResourceRouter
extends RestxRouter {
    public JsonSchemaResourceRouter(final JsonSchemaResource resource, EntityRequestBodyReaderRegistry readerRegistry, EntityResponseWriterRegistry writerRegistry, MainStringConverter converter, PermissionFactory pf, final Optional<Validator> validator, final RestxSecurityManager securityManager, EndpointParameterMapperRegistry paramMapperRegistry) {
        super("restx-admin", "JsonSchemaResourceRouter", new RestxRoute[]{new StdEntityRoute<Void, String>("restx-admin#JsonSchemaResource#getJsonSchema", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build(String.class, Optional.absent()), Endpoint.of((String)"GET", (String)"/@/api-docs/schemas/{fqcn}"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[]{ParamDef.of((TypeReference)new TypeReference<String>(){}, (String)"fqcn")}){

            protected Optional<String> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of((Object)resource.getJsonSchema((String)Validations.checkValid((Optional)validator, (Object)Preconditions.checkNotNull((Object)this.mapQueryObjectFromRequest(String.class, "fqcn", request, match, EndpointParameterKind.PATH), (Object)"PATH param <fqcn> is required"), (Class[])new Class[0])));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription fqcn = new OperationParameterDescription();
                fqcn.name = "fqcn";
                fqcn.paramType = OperationParameterDescription.ParamType.path;
                fqcn.dataType = "string";
                fqcn.schemaKey = "";
                fqcn.required = true;
                operation.parameters.add(fqcn);
                operation.responseClass = "string";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "";
                operation.outEntityType = String.class;
                operation.sourceLocation = "restx.apidocs.JsonSchemaResource#getJsonSchema(java.lang.String)";
                operation.annotations = ImmutableList.builder().add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/api-docs/schemas/{fqcn}";
                    }
                }).add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).build();
            }
        }});
    }
}

