/*
 * Decompiled with CFR 0.152.
 */
package restx.apidocs;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import restx.annotations.GET;
import restx.annotations.PUT;
import restx.annotations.RestxResource;
import restx.factory.Component;
import restx.security.RolesAllowed;
import restx.specs.RestxSpec;
import restx.specs.RestxSpecRepository;
import restx.specs.Then;
import restx.specs.ThenHttpResponse;
import restx.specs.When;

@Component
@RestxResource(group="restx-admin")
public class SpecsResource {
    private final RestxSpecRepository repository;
    private final RestxSpec.Storage storage;

    public SpecsResource(RestxSpecRepository repository, RestxSpec.StorageSettings storageSettings) {
        this.repository = repository;
        this.storage = RestxSpec.Storage.with((RestxSpec.StorageSettings)storageSettings);
    }

    @RolesAllowed(value={"restx-admin"})
    @GET(value="/@/specs")
    public Iterable<String> findSpecsForOperation(String httpMethod, String path) {
        return this.repository.findSpecsByOperation(httpMethod, path);
    }

    @RolesAllowed(value={"restx-admin"})
    @GET(value="/@/specs/{id}")
    public Optional<RestxSpec> getSpecById(String id) {
        try {
            String specId = URLDecoder.decode(id, Charsets.UTF_8.name()).replace("___", "/");
            return this.repository.findSpecById(specId);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @RolesAllowed(value={"restx-admin"})
    @PUT(value="/@/specs/{id}/wts/{wtsIndex}/then")
    public Optional<ThenHttpResponse> updateSpecThenHttp(String id, int wtsIndex, ThenHttpResponse response) throws IOException {
        try {
            Optional spec = this.repository.findSpecById(URLDecoder.decode(id, Charsets.UTF_8.name()));
            if (!spec.isPresent()) {
                return Optional.absent();
            }
            if (wtsIndex >= ((RestxSpec)spec.get()).getWhens().size()) {
                return Optional.absent();
            }
            When<ThenHttpResponse> when = this.asWhenHttp((When)((RestxSpec)spec.get()).getWhens().get(wtsIndex));
            this.storage.store(((RestxSpec)spec.get()).withWhenAt(wtsIndex, when.withThen((Then)response)));
            return Optional.of((Object)response);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private When<ThenHttpResponse> asWhenHttp(When<?> when) {
        return when;
    }
}

