/*
 * Decompiled with CFR 0.152.
 */
package com.chrylis.codec.base58;

import com.chrylis.codec.base58.Base58Codec;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.UUID;
import org.springframework.cache.annotation.Cacheable;

@Cacheable(value={"base58uuid"})
public class Base58UUID {
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public String encode(UUID uuid) {
        ByteBuffer bb = ByteBuffer.allocate(17);
        bb.put((byte)0);
        bb.putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).flip();
        return Base58Codec.doEncode(bb.array());
    }

    public UUID decode(String base58) {
        ByteBuffer bb = ByteBuffer.wrap(Base58Codec.doDecode(base58, 16));
        return new UUID(bb.getLong(), bb.getLong());
    }

    public String encodeUuidFromName(String name) {
        return this.encode(UUID.nameUUIDFromBytes(name.getBytes(UTF_8)));
    }
}

