/*
 * Decompiled with CFR 0.152.
 */
package restx.common;

import com.google.common.base.Preconditions;

public class ConfigElement {
    private final String origin;
    private final String doc;
    private final String key;
    private final String value;

    public static ConfigElement of(String key, String val) {
        return new ConfigElement("", "", key, val);
    }

    public static ConfigElement of(String origin, String doc, String key, String val) {
        return new ConfigElement(origin, doc, key, val);
    }

    private ConfigElement(String origin, String doc, String key, String value) {
        this.origin = (String)Preconditions.checkNotNull((Object)origin);
        this.doc = (String)Preconditions.checkNotNull((Object)doc);
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.value = (String)Preconditions.checkNotNull((Object)value);
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getDoc() {
        return this.doc;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public ConfigElement withDoc(String doc) {
        return new ConfigElement(this.origin, doc, this.key, this.value);
    }

    public String toString() {
        return "ConfigElement{origin='" + this.origin + '\'' + ", doc='" + this.doc + '\'' + ", key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
    }
}

