/*
 * Decompiled with CFR 0.152.
 */
package restx.common;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;

public class MorePreconditions {
    public static <T> T checkPresent(Optional<T> optional, String msg, Object ... parameters) {
        if (optional.isPresent()) {
            return (T)optional.get();
        }
        throw new IllegalStateException(String.format(msg, parameters));
    }

    public static <T> T checkEquals(String name1, T o1, String name2, T o2) {
        Preconditions.checkArgument((boolean)Objects.equal(o1, o2), (String)"%s %s must be equal to %s %s", (Object[])new Object[]{name1, o1, name2, o2});
        return o1;
    }

    public static <T> T checkInstanceOf(String name, Object o, Class<T> clazz) {
        Preconditions.checkNotNull((Object)o, (String)"%s must not be null and be an instance of %s", (Object[])new Object[]{name, clazz.getName()});
        Preconditions.checkArgument((boolean)clazz.isInstance(o), (String)"%s %s must be an instanceof of %s - but it is a %s", (Object[])new Object[]{name, o, clazz.getSimpleName(), o.getClass().getName()});
        return (T)o;
    }

    public static <K, V> V checkContainsKey(String name, Map<K, V> map, K key) {
        Preconditions.checkArgument((boolean)map.containsKey(key), (String)"%s map must contain key value for key %s", (Object[])new Object[]{name, key});
        return map.get(key);
    }
}

