/*
 * Decompiled with CFR 0.152.
 */
package restx.common;

import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class MoreResources {
    public static URL getResource(String resourceName, boolean searchInSources) {
        URL resource = null;
        if (searchInSources) {
            Set urls = ClasspathHelper.forResource((String)resourceName, (ClassLoader[])new ClassLoader[0]);
            for (URL url : urls) {
                if (!url.getProtocol().equals("file")) continue;
                block3: for (String classesLocation : Arrays.asList("target/classes/", "bin/")) {
                    if (!url.getFile().endsWith(classesLocation)) continue;
                    for (String sourcesLocation : Arrays.asList("src/main/resources/", "src/")) {
                        File file = new File(url.getFile().replace(classesLocation, ""), sourcesLocation + resourceName);
                        if (!file.exists()) continue;
                        try {
                            resource = file.toURI().toURL();
                        }
                        catch (MalformedURLException malformedURLException) {}
                        continue block3;
                    }
                }
            }
        }
        if (resource == null) {
            resource = Resources.getResource((String)resourceName);
        }
        return resource;
    }

    public static Map<String, URL> findResources(String packageName, final Pattern p, boolean searchInSources) {
        final LinkedHashMap<String, URL> resourcesUrls = new LinkedHashMap<String, URL>();
        if (searchInSources) {
            Set<Path> sourceRoots = MoreResources.findSourceRoots();
            for (final Path sourceRoot : sourceRoots) {
                try {
                    Files.walkFileTree(sourceRoot.resolve(packageName.replace('.', '/')), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                            if (p.matcher(file.getFileName().toString()).matches()) {
                                try {
                                    String resource = sourceRoot.relativize(file).toString();
                                    if (!resourcesUrls.containsKey(resource)) {
                                        resourcesUrls.put(resource, file.toUri().toURL());
                                    }
                                }
                                catch (MalformedURLException malformedURLException) {
                                    // empty catch block
                                }
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException iOException) {}
            }
        }
        for (String r : new ConfigurationBuilder().setUrls((Collection)ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new ResourcesScanner()}).build().getResources(p)) {
            if (resourcesUrls.containsKey(r) || !r.startsWith(packageName.replace('.', '/'))) continue;
            resourcesUrls.put(r, Resources.getResource((String)r));
        }
        return resourcesUrls;
    }

    private static Set<Path> findSourceRoots() {
        LinkedHashSet<Path> sourceRoots = new LinkedHashSet<Path>();
        Set urls = ClasspathHelper.forClassLoader();
        for (URL url : urls) {
            if (!url.getProtocol().equals("file")) continue;
            block1: for (String classesLocation : Arrays.asList("target/classes/", "bin/")) {
                if (!url.getFile().endsWith(classesLocation)) continue;
                for (String sourcesLocation : Arrays.asList("src/main/resources/", "src/")) {
                    File sourceRoot = new File(url.getFile().replace(classesLocation, ""), sourcesLocation);
                    if (!sourceRoot.exists()) continue;
                    sourceRoots.add(sourceRoot.toPath());
                    continue block1;
                }
            }
        }
        return sourceRoots;
    }
}

