/*
 * Decompiled with CFR 0.152.
 */
package restx.common;

import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;

public class Mustaches {
    public static Template compile(Class relativeTo, String name) {
        return Mustaches.compile(name, Resources.asCharSource((URL)Resources.getResource((Class)relativeTo, (String)name), (Charset)Charsets.UTF_8));
    }

    public static Template compile(String name) {
        return Mustaches.compile(name, Resources.asCharSource((URL)Resources.getResource((String)name), (Charset)Charsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Template compile(String name, CharSource charSource) {
        try (BufferedReader reader = charSource.openBufferedStream();){
            Template template = Mustaches.createCompiler().compile((Reader)reader);
            return template;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Template compileTemplate(String template) {
        return Mustaches.createCompiler().compile(template);
    }

    private static Mustache.Compiler createCompiler() {
        return Mustache.compiler().escapeHTML(false);
    }

    public static Template compileTemplateWithSingleBrackets(String templateWithSingleBrackets) {
        String templateWithDoubleBrackets = templateWithSingleBrackets.replaceAll("\\{", "{{").replaceAll("}", "}}");
        return Mustaches.compileTemplate(templateWithDoubleBrackets);
    }

    public static String execute(Template mustache, Object scope) {
        return mustache.execute(scope);
    }

    public static void execute(Template mustache, Object scope, Path path) throws IOException {
        File file = path.toFile();
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IOException(String.format("can't generate file to `%s`: can't create directory `%s`", file.getAbsolutePath(), file.getParentFile().getAbsolutePath()));
        }
        try (FileWriter w = new FileWriter(file);){
            mustache.execute(scope, (Writer)w);
        }
    }
}

