/*
 * Decompiled with CFR 0.152.
 */
package restx.common;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import restx.common.ConfigElement;
import restx.common.RestxConfig;

public class StdRestxConfig
implements RestxConfig {
    private static final Collection TRUE_VALUES = Arrays.asList("true", "yes", "on", "1", "y");
    private final ImmutableMap<String, ConfigElement> elements;

    public static RestxConfig parse(String origin, CharSource charSource) throws IOException {
        ArrayList<ConfigElement> elements = new ArrayList<ConfigElement>();
        StringBuilder doc = new StringBuilder();
        ImmutableList lines = charSource.readLines();
        for (int lineCount = 0; lineCount < lines.size(); ++lineCount) {
            String line = (String)lines.get(lineCount);
            if (line.startsWith("#")) {
                doc.append(line.substring(1).trim()).append("\n");
                continue;
            }
            if (line.trim().isEmpty()) continue;
            int equalIndex = line.indexOf(61);
            if (equalIndex == -1) {
                throw new IOException("invalid config " + origin + " at line " + lineCount + ":" + " line does not contain the equals sign '='");
            }
            String key = line.substring(0, equalIndex).trim();
            StringBuilder value = new StringBuilder();
            String lineValue = line.substring(equalIndex + 1).trim();
            while (lineValue.endsWith("\\") && lineCount + 1 < lines.size()) {
                value.append(lineValue.substring(0, lineValue.length() - "\\".length()));
                lineValue = ((String)lines.get(++lineCount)).trim();
            }
            value.append(lineValue);
            elements.add(ConfigElement.of(origin, doc.toString().trim(), key, value.toString()));
            doc.setLength(0);
        }
        return new StdRestxConfig(elements);
    }

    public static RestxConfig of(Iterable<ConfigElement> configElements) {
        return new StdRestxConfig(configElements);
    }

    private StdRestxConfig(Iterable<ConfigElement> elements) {
        LinkedHashMap<String, ConfigElement> m = new LinkedHashMap<String, ConfigElement>();
        for (ConfigElement element : elements) {
            ConfigElement curElement = (ConfigElement)m.get(element.getKey());
            if (curElement == null) {
                m.put(element.getKey(), element);
                continue;
            }
            if (!Strings.isNullOrEmpty((String)curElement.getDoc()) || Strings.isNullOrEmpty((String)element.getDoc())) continue;
            m.put(element.getKey(), curElement.withDoc(element.getDoc()));
        }
        this.elements = ImmutableMap.copyOf(m);
    }

    @Override
    public Iterable<ConfigElement> elements() {
        return this.elements.values();
    }

    @Override
    public Optional<ConfigElement> getElement(String elementKey) {
        return Optional.fromNullable((Object)this.elements.get((Object)elementKey));
    }

    @Override
    public Optional<String> getString(String elementKey) {
        ConfigElement element = (ConfigElement)this.elements.get((Object)elementKey);
        if (element == null || Strings.isNullOrEmpty((String)element.getValue())) {
            return Optional.absent();
        }
        return Optional.of((Object)element.getValue());
    }

    @Override
    public Optional<Integer> getInt(String elementKey) {
        ConfigElement element = (ConfigElement)this.elements.get((Object)elementKey);
        if (element == null || Strings.isNullOrEmpty((String)element.getValue())) {
            return Optional.absent();
        }
        try {
            return Optional.of((Object)Integer.parseInt(element.getValue()));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("can't access " + element + " as int" + " (parse exception " + e.getMessage() + ")");
        }
    }

    @Override
    public Optional<Long> getLong(String elementKey) {
        ConfigElement element = (ConfigElement)this.elements.get((Object)elementKey);
        if (element == null || Strings.isNullOrEmpty((String)element.getValue())) {
            return Optional.absent();
        }
        try {
            return Optional.of((Object)Long.parseLong(element.getValue()));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("can't access " + element + " as long" + " (parse exception " + e.getMessage() + ")");
        }
    }

    @Override
    public Optional<Boolean> getBoolean(String elementKey) {
        ConfigElement element = (ConfigElement)this.elements.get((Object)elementKey);
        if (element == null || Strings.isNullOrEmpty((String)element.getValue())) {
            return Optional.absent();
        }
        return Optional.of((Object)TRUE_VALUES.contains(element.getValue().toLowerCase(Locale.ENGLISH)));
    }
}

