/*
 * Decompiled with CFR 0.152.
 */
package restx.common;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.UUID;

public interface UUIDGenerator {
    public String doGenerate();

    public static class PlaybackUUIDGenerator
    implements UUIDGenerator {
        private final Iterator<String> sequence;

        public static UUIDGenerator playbackUUIDs(String ... uuids) {
            return new PlaybackUUIDGenerator(Lists.newArrayList((Object[])uuids).iterator());
        }

        public static UUIDGenerator playbackUUIDs(Iterable<String> uuids) {
            return new PlaybackUUIDGenerator(uuids.iterator());
        }

        private PlaybackUUIDGenerator(Iterator<String> sequence) {
            this.sequence = sequence;
        }

        @Override
        public String doGenerate() {
            if (this.sequence.hasNext()) {
                return this.sequence.next();
            }
            throw new IllegalStateException("no more uuids in sequence");
        }
    }

    public static class DefaultUUIDGenerator
    implements UUIDGenerator {
        @Override
        public String doGenerate() {
            return UUID.randomUUID().toString();
        }
    }
}

