/*
 * Decompiled with CFR 0.152.
 */
package restx.common.processor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.samskivert.mustache.Template;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public abstract class RestxAbstractProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this.processImpl(annotations, roundEnv);
        }
        catch (Exception e) {
            this.fatalError("", e);
            return true;
        }
    }

    protected abstract boolean processImpl(Set<? extends TypeElement> var1, RoundEnvironment var2) throws Exception;

    protected void log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    protected void error(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
    }

    protected void warn(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg, element);
    }

    protected void error(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element, annotation);
    }

    protected void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }

    protected void fatalError(String msg, Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg + " " + writer);
    }

    protected void fatalError(String msg, Exception e, Element element) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg + " " + writer, element);
    }

    protected PackageElement getPackage(TypeElement typeElement) {
        for (Element el = typeElement.getEnclosingElement(); el != null; el = el.getEnclosingElement()) {
            if (!(el instanceof PackageElement)) continue;
            return (PackageElement)el;
        }
        throw new IllegalStateException("no package for " + typeElement);
    }

    protected TypeElement asTypeElement(TypeMirror typeMirror) {
        Types TypeUtils = this.processingEnv.getTypeUtils();
        return (TypeElement)TypeUtils.asElement(typeMirror);
    }

    protected void generateJavaClass(String className, Template mustache, ImmutableMap<String, Object> ctx, Element originatingElements) throws IOException {
        this.generateJavaClass(className, mustache, ctx, (Set<Element>)ImmutableSet.of((Object)originatingElements));
    }

    protected void generateJavaClass(String className, Template mustache, ImmutableMap<String, ? extends Object> ctx, Set<Element> originatingElements) throws IOException {
        JavaFileObject fileObject = this.processingEnv.getFiler().createSourceFile(className, (Element[])Iterables.toArray(originatingElements, Element.class));
        try (Writer writer = fileObject.openWriter();){
            mustache.execute(ctx, writer);
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    protected abstract class ResourceDeclaration {
        private final String targetFilePath;
        private FileObject fileObject;

        protected ResourceDeclaration(String targetFilePath) {
            this.targetFilePath = targetFilePath;
        }

        protected abstract boolean requireGeneration();

        protected abstract void clearContent();

        protected abstract void writeContent(Writer var1) throws IOException;

        protected abstract void readContent(Reader var1) throws IOException;

        public void generate() throws IOException {
            if (!this.requireGeneration()) {
                return;
            }
            this.writeResourceFile(this.targetFilePath);
            this.clearContent();
            this.fileObject = null;
        }

        public void processing() throws IOException {
            this.readExistingResourceIfExists(this.targetFilePath);
        }

        private void writeResourceFile(String targetFile) throws IOException {
            if (this.fileObject == null || !this.fileObject.getClass().getSimpleName().equals("EclipseFileObject")) {
                try {
                    this.fileObject = RestxAbstractProcessor.this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", targetFile, new Element[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try (Writer writer = this.fileObject.openWriter();){
                this.writeContent(writer);
            }
        }

        private void readExistingResourceIfExists(String targetFile) throws IOException {
            block32: {
                try {
                    if (this.fileObject == null) {
                        this.fileObject = RestxAbstractProcessor.this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", targetFile);
                    }
                    try (Reader r = this.fileObject.openReader(true);){
                        this.readContent(r);
                    }
                }
                catch (FileNotFoundException ex) {
                    try {
                        File file = new File(ex.getMessage());
                        if (!file.exists()) break block32;
                        try (FileReader r = new FileReader(file);){
                            this.readContent(r);
                        }
                        catch (IOException iOException) {
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (IOException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
        }
    }
}

