/*
 * Decompiled with CFR 0.152.
 */
package restx.common.watch;

import com.google.common.eventbus.EventBus;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class EventCoalescor<T>
implements Closeable {
    final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    final EventBus eventBus;
    final long coalescePeriod;

    public static EventCoalescor<Object> generic(EventBus eventBus, long coalescePeriod) {
        return new GenericEventCoalescor(eventBus, coalescePeriod);
    }

    EventCoalescor(EventBus eventBus, long coalescePeriod) {
        this.eventBus = eventBus;
        this.coalescePeriod = coalescePeriod;
    }

    public abstract void post(T var1);

    @Override
    public void close() throws IOException {
        this.executor.shutdownNow();
    }

    private static class GenericEventCoalescor
    extends EventCoalescor<Object> {
        private final Set<Object> queue = new LinkedHashSet<Object>();

        private GenericEventCoalescor(EventBus eventBus, long coalescePeriod) {
            super(eventBus, coalescePeriod);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void post(final Object event) {
            Set<Object> set = this.queue;
            synchronized (set) {
                if (this.queue.add(event)) {
                    this.executor.schedule(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                GenericEventCoalescor.this.eventBus.post(event);
                            }
                            finally {
                                Set set = GenericEventCoalescor.this.queue;
                                synchronized (set) {
                                    GenericEventCoalescor.this.queue.remove(event);
                                }
                            }
                        }
                    }, this.coalescePeriod, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

