/*
 * Decompiled with CFR 0.152.
 */
package restx.common.watch;

import java.nio.file.Path;
import java.nio.file.WatchEvent;

public class FileWatchEvent {
    private final Path dir;
    private final Path path;
    private final WatchEvent.Kind<?> kind;
    private final int count;

    public static FileWatchEvent newInstance(Path root, Path dir, Path path, WatchEvent.Kind<?> kind, int count) {
        return new FileWatchEvent(root, FileWatchEvent.normalizePath(root, dir.resolve(FileWatchEvent.normalizePath(dir, path))), kind, count);
    }

    public static FileWatchEvent fromWithKind(FileWatchEvent ref, WatchEvent.Kind<?> newKind) {
        return new FileWatchEvent(ref.dir, ref.path, newKind, ref.count);
    }

    private FileWatchEvent(Path dir, Path path, WatchEvent.Kind<?> kind, int count) {
        this.dir = dir;
        this.path = path;
        this.kind = kind;
        this.count = count;
    }

    public Path getDir() {
        return this.dir;
    }

    public Path getPath() {
        return this.path;
    }

    public WatchEvent.Kind<?> getKind() {
        return this.kind;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        return "FileWatchEvent{dir=" + this.dir + ", path=" + this.path + ", kind=" + this.kind + ", count=" + this.count + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileWatchEvent that = (FileWatchEvent)o;
        if (!this.dir.equals(that.dir)) {
            return false;
        }
        if (!this.kind.equals(that.kind)) {
            return false;
        }
        return this.path.equals(that.path);
    }

    public int hashCode() {
        int result = this.dir.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.kind.hashCode();
        return result;
    }

    private static Path normalizePath(Path dir, Path path) {
        if (path.startsWith(dir)) {
            return dir.relativize(path);
        }
        if (path.isAbsolute() && path.startsWith(dir.toAbsolutePath())) {
            return dir.toAbsolutePath().relativize(path);
        }
        return path;
    }
}

