/*
 * Decompiled with CFR 0.152.
 */
package restx.config.processor;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Template;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import restx.common.Mustaches;
import restx.common.processor.RestxAbstractProcessor;
import restx.config.Settings;
import restx.config.SettingsKey;

@SupportedAnnotationTypes(value={"restx.config.Settings"})
@SupportedOptions(value={"debug"})
public class SettingsAnnotationProcessor
extends RestxAbstractProcessor {
    final Template settingsProviderTpl = Mustaches.compile(SettingsAnnotationProcessor.class, (String)"SettingsProvider.mustache");
    final Template settingsConfigTpl = Mustaches.compile(SettingsAnnotationProcessor.class, (String)"SettingsConfig.mustache");

    protected boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        for (Element element : roundEnv.getElementsAnnotatedWith(Settings.class)) {
            try {
                TypeElement typeElement = (TypeElement)element;
                if (!typeElement.getKind().isInterface()) {
                    this.error(String.format("only an interface can be annotated with @Settings - %s", typeElement.getSimpleName()), typeElement);
                    continue;
                }
                String fqcn = typeElement.getQualifiedName().toString();
                String pack = this.getPackage(typeElement).getQualifiedName().toString();
                String settingsSimpleType = typeElement.getSimpleName().toString();
                boolean shouldGenerateProvider = false;
                ArrayList<ImmutableMap> keys = new ArrayList<ImmutableMap>();
                block18: for (Element element2 : typeElement.getEnclosedElements()) {
                    String configAccessor;
                    String suffix;
                    String prefix;
                    String targetType;
                    if (element2.getKind() != ElementKind.METHOD) continue;
                    ExecutableElement methodElem = (ExecutableElement)element2;
                    if (!methodElem.getParameters().isEmpty()) {
                        this.error("invalid settings accessor method - it must not take any parameter", methodElem);
                        continue;
                    }
                    String accessorReturnType = methodElem.getReturnType().toString();
                    boolean guavaOptional = accessorReturnType.startsWith(Optional.class.getCanonicalName());
                    boolean java8Optional = accessorReturnType.startsWith("java.util.Optional");
                    if (guavaOptional || java8Optional) {
                        List<? extends TypeMirror> typeArguments = ((DeclaredType)methodElem.getReturnType()).getTypeArguments();
                        if (typeArguments.isEmpty()) {
                            this.error(String.format("unsupported return type %s for settings accessor method - you must provide generic type when using Optional", accessorReturnType), methodElem);
                            continue;
                        }
                        targetType = typeArguments.get(0).toString();
                    } else {
                        targetType = accessorReturnType;
                    }
                    if (guavaOptional) {
                        prefix = "";
                        suffix = "";
                    } else if (java8Optional) {
                        prefix = "java.util.Optional.ofNullable(";
                        suffix = ".orNull())";
                    } else {
                        prefix = "";
                        suffix = ".get()";
                    }
                    switch (targetType) {
                        case "java.lang.String": {
                            configAccessor = "getString";
                            break;
                        }
                        case "java.lang.Integer": 
                        case "int": {
                            configAccessor = "getInt";
                            break;
                        }
                        case "java.lang.Long": 
                        case "long": {
                            configAccessor = "getLong";
                            break;
                        }
                        case "java.lang.Boolean": 
                        case "boolean": {
                            configAccessor = "getBoolean";
                            break;
                        }
                        default: {
                            this.error(String.format("unsupported return type %s for settings accessor method - it must be one of [String, Integer, int, Long, long, Boolean, boolean]", accessorReturnType), methodElem);
                            continue block18;
                        }
                    }
                    SettingsKey settingsKey = element2.getAnnotation(SettingsKey.class);
                    if (settingsKey == null) {
                        this.error(String.format("all methods in a Settings interface must be annotated with @SettingsKey - %s", element2.getSimpleName()), element2);
                        continue;
                    }
                    shouldGenerateProvider |= !Strings.isNullOrEmpty((String)settingsKey.defaultValue()) || !Strings.isNullOrEmpty((String)settingsKey.doc());
                    keys.add(ImmutableMap.builder().put((Object)"accessorReturnType", (Object)accessorReturnType).put((Object)"configAccessor", (Object)configAccessor).put((Object)"accessorName", (Object)methodElem.getSimpleName().toString()).put((Object)"key", (Object)settingsKey.key()).put((Object)"prefix", (Object)prefix).put((Object)"suffix", (Object)suffix).put((Object)"doc", (Object)settingsKey.doc()).put((Object)"defaultValue", (Object)settingsKey.defaultValue()).build());
                }
                ImmutableMap ctx = ImmutableMap.builder().put((Object)"package", (Object)pack).put((Object)"settingsSimpleType", (Object)settingsSimpleType).put((Object)"settingsType", (Object)fqcn).put((Object)"keys", keys).build();
                this.generateJavaClass(pack + "." + settingsSimpleType + "Config", this.settingsConfigTpl, ctx, element);
                if (!shouldGenerateProvider) continue;
                this.generateJavaClass(pack + "." + settingsSimpleType + "Provider", this.settingsProviderTpl, ctx, element);
            }
            catch (Exception e) {
                this.fatalError("error when processing " + element, e, element);
            }
        }
        return true;
    }
}

