/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import restx.factory.FactoryMachine;
import restx.factory.MachineEngine;
import restx.factory.Name;

public class DefaultFactoryMachine
implements FactoryMachine {
    private final int priority;
    protected final ImmutableMap<Name<?>, MachineEngine<?>> engines;

    public DefaultFactoryMachine(int priority, MachineEngine<?> ... engines) {
        this.priority = priority;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MachineEngine<?> engine : engines) {
            builder.put(engine.getName(), engine);
        }
        this.engines = builder.build();
    }

    @Override
    public boolean canBuild(Name<?> name) {
        return this.engines.containsKey(name);
    }

    @Override
    public <T> MachineEngine<T> getEngine(Name<T> name) {
        return (MachineEngine)this.engines.get(name);
    }

    @Override
    public <T> Set<Name<T>> nameBuildableComponents(Class<T> componentClass) {
        HashSet names = Sets.newHashSet();
        for (Name name : this.engines.keySet()) {
            if (!componentClass.isAssignableFrom(name.getClazz())) continue;
            names.add(name);
        }
        return names;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    public String toString() {
        return "DefaultFactoryMachine{priority=" + this.priority + ", engines=" + this.engines + '}';
    }
}

