/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.common.MoreObjects;
import restx.common.MorePreconditions;
import restx.common.MoreStrings;
import restx.common.metrics.api.MetricRegistry;
import restx.common.metrics.api.Monitor;
import restx.common.metrics.api.Timer;
import restx.common.metrics.dummy.DummyMetricRegistry;
import restx.factory.AutoPreparable;
import restx.factory.AutoStartable;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.ComponentBox;
import restx.factory.ComponentCustomizer;
import restx.factory.ComponentCustomizerEngine;
import restx.factory.FactoryMachine;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.NoDepsMachineEngine;
import restx.factory.SatisfiedBOM;
import restx.factory.SingleNameFactoryMachine;
import restx.factory.SingletonFactoryMachine;
import restx.factory.StdWarehouse;
import restx.factory.Warehouse;
import restx.factory.WarehouseProvidersMachine;

public class Factory
implements AutoCloseable {
    public static final String METRICS_REGISTRY = "MetricRegistry";
    public static final String HEALTH_CHECK_REGISTRY = "HealthChekcRegistry";
    public static final Comparator<MachineEngine<?>> ENGINE_COMPARATOR = new Comparator<MachineEngine<?>>(){

        @Override
        public int compare(MachineEngine<?> o1, MachineEngine<?> o2) {
            return Factory.compareByPriorityAndName(o1.getPriority(), o1.getName(), o2.getPriority(), o2.getName());
        }
    };
    public static final Comparator<NamedComponent<?>> NAMED_COMPONENT_COMPARATOR = new Comparator<NamedComponent<?>>(){

        @Override
        public int compare(NamedComponent<?> o1, NamedComponent<?> o2) {
            return Factory.compareByPriorityAndName(o1.getPriority(), o1.getName(), o2.getPriority(), o2.getName());
        }
    };
    private static final String SERVICE_LOADER = "ServiceLoader";
    private static final Logger logger = LoggerFactory.getLogger(Factory.class);
    private static final Name<Factory> FACTORY_NAME = Name.of(Factory.class, "FACTORY");
    private static final Name<MetricRegistry> METRICS_NAME = Name.of(MetricRegistry.class, "MetricRegistry");
    private static final Comparator<ComponentCustomizer> customizerComparator = new Comparator<ComponentCustomizer>(){

        @Override
        public int compare(ComponentCustomizer o1, ComponentCustomizer o2) {
            return o1.priority() - o2.priority();
        }
    };
    private static final AtomicLong ID = new AtomicLong();
    private static final ConcurrentMap<String, Factory> factories = Maps.newConcurrentMap();
    private final boolean usedServiceLoader;
    private final ImmutableList<FactoryMachine> machines;
    private final ImmutableMultimap<String, FactoryMachine> machinesByBuilder;
    private final Warehouse warehouse;
    private final ImmutableList<ComponentCustomizerEngine> customizerEngines;
    private final String id;
    private final Object dumper = new Object(){

        public String toString() {
            return Factory.this.dump();
        }
    };
    private final Set<Name> deactivatedComponents = new CopyOnWriteArraySet<Name>();
    private final Set<Name> activatedComponents = new CopyOnWriteArraySet<Name>();
    private MetricRegistry metrics;

    private static int compareByPriorityAndName(int p1, Name<?> n1, int p2, Name<?> n2) {
        int priorityComparison = Integer.compare(p1, p2);
        if (priorityComparison == 0) {
            return n1.asId().compareTo(n2.asId());
        }
        return priorityComparison;
    }

    public static Optional<Factory> getFactory(String key) {
        return Optional.fromNullable(factories.get(key));
    }

    public static Factory register(String key, Factory factory) {
        Factory previous = factories.putIfAbsent(key, factory);
        if (previous != null) {
            return previous;
        }
        return factory;
    }

    public static boolean unregister(String key, Factory factory) {
        return factories.remove(key, factory);
    }

    public static Factory newInstance() {
        return Factory.builder().addFromServiceLoader().addLocalMachines(LocalMachines.threadLocal()).build();
    }

    public static Factory getInstance() {
        Optional<Factory> factory = Factory.getFactory("__DEFAULT__");
        if (factory.isPresent()) {
            return (Factory)factory.get();
        }
        return Factory.register("__DEFAULT__", Factory.builder().addFromServiceLoader().build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static <T> String activationKey(Class<T> aClass, String name) {
        return "restx.activation::" + aClass.getName() + "::" + name;
    }

    private Factory(boolean usedServiceLoader, Multimap<String, FactoryMachine> machines, ImmutableList<ComponentCustomizerEngine> customizerEngines, Warehouse warehouse) {
        this.usedServiceLoader = usedServiceLoader;
        this.customizerEngines = customizerEngines;
        ImmutableMultimap.Builder machineBuilder = ImmutableMultimap.builder().put((Object)"FactoryMachine", new SingletonFactoryMachine<Factory>(10000, new NamedComponent<Factory>(FACTORY_NAME, this))).put((Object)"MetricRegistryMachine", new SingleNameFactoryMachine<MetricRegistry>(10000, new NoDepsMachineEngine<MetricRegistry>(METRICS_NAME, 10000, BoundlessComponentBox.FACTORY){

            @Override
            protected MetricRegistry doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new DummyMetricRegistry();
            }
        }));
        if (!warehouse.getProviders().isEmpty()) {
            machineBuilder.put((Object)"WarehouseProvidersMachine", (Object)new WarehouseProvidersMachine(warehouse.getProviders()));
        }
        this.machinesByBuilder = machineBuilder.putAll(machines).build();
        this.machines = ImmutableList.copyOf((Collection)Ordering.from((Comparator)new Comparator<FactoryMachine>(){

            @Override
            public int compare(FactoryMachine o1, FactoryMachine o2) {
                return Integer.compare(o1.priority(), o2.priority());
            }
        }).sortedCopy((Iterable)this.machinesByBuilder.values()));
        this.id = String.format("%03d-%s(%d)", ID.incrementAndGet(), warehouse.getId(), this.machinesByBuilder.size());
        this.warehouse = (Warehouse)Preconditions.checkNotNull((Object)warehouse);
        this.metrics = new DummyMetricRegistry();
        this.metrics = this.getComponent(MetricRegistry.class);
    }

    public Factory concat(FactoryMachine machine) {
        ArrayListMultimap machines = ArrayListMultimap.create();
        machines.putAll(this.machinesByBuilder);
        machines.removeAll((Object)"FactoryMachine");
        machines.removeAll((Object)"MetricRegistryMachine");
        machines.removeAll((Object)"WarehouseProvidersMachine");
        machines.put((Object)"IndividualMachines", (Object)machine);
        return new Factory(this.usedServiceLoader, (Multimap<String, FactoryMachine>)machines, this.customizerEngines, new StdWarehouse(this.warehouse.getProviders()));
    }

    public String getId() {
        return this.id;
    }

    public Warehouse getWarehouse() {
        return this.warehouse;
    }

    public int getNbMachines() {
        return this.machines.size();
    }

    public <T> Query<T> queryByName(Name<T> name) {
        return new NameQuery<T>(name).bind(this);
    }

    public <T> Query<T> queryByClass(Class<T> componentClass) {
        return new ClassQuery<T>(componentClass).bind(this);
    }

    public <T> T getComponent(Class<T> componentClass) {
        return (T)MorePreconditions.checkPresent(this.queryByClass(componentClass).mandatory().findOneAsComponent(), (String)"component of class %s not found", (Object[])new Object[]{componentClass});
    }

    public <T> T getComponent(Name<T> componentName) {
        return (T)MorePreconditions.checkPresent(this.queryByName(componentName).mandatory().findOneAsComponent(), (String)"component of name %s not found", (Object[])new Object[]{componentName});
    }

    public <T> Set<T> getComponents(Class<T> componentClass) {
        return this.queryByClass(componentClass).findAsComponents();
    }

    public Factory and() {
        return this;
    }

    public Factory start() {
        for (AutoStartable startable : this.queryByClass(AutoStartable.class).findAsComponents()) {
            startable.start();
        }
        return this;
    }

    public Factory prepare() {
        for (AutoPreparable preparable : this.queryByClass(AutoPreparable.class).findAsComponents()) {
            preparable.prepare();
        }
        return this;
    }

    @Override
    public void close() {
        this.warehouse.close();
    }

    public String toString() {
        return "Factory[" + this.id + "]";
    }

    public Object dumper() {
        return this.dumper;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder().append("---------------------------------------------\n").append("             Factory ").append(this.id).append("\n");
        sb.append("--> Machines by priority\n  ");
        Joiner.on((String)"\n  ").appendTo(sb, this.machines);
        sb.append("\n--\n");
        sb.append("--> Machines by builder\n");
        for (String builder : this.machinesByBuilder.keySet()) {
            ImmutableCollection machinesForBuilder = this.machinesByBuilder.get((Object)builder);
            sb.append("  = ").append(builder).append("(").append(machinesForBuilder.size()).append(" machines) =\n");
            for (FactoryMachine machine : machinesForBuilder) {
                sb.append("     ").append(machine).append("\n");
            }
        }
        sb.append("--\n");
        this.dumpBuidableComponents(sb);
        this.dumpDeactivatedComponents(sb);
        Set<String> undeclaredMachines = this.findUndeclaredMachines();
        if (!undeclaredMachines.isEmpty()) {
            sb.append("--> WARNING: classes annotated with @Machine were found in classpath\n").append("             but not in service declaration files `META-INF/services/restx.factory.FactoryMachine`.\n").append("             Do a clean build and check your annotation processing.\n").append("             List of missing machines:\n");
            for (String undeclaredMachine : undeclaredMachines) {
                sb.append("  ").append(undeclaredMachine).append("\n");
            }
            sb.append("\n--\n");
        }
        sb.append("--> Warehouse\n  ").append(this.warehouse).append("\n--\n");
        sb.append("---------------------------------------------");
        return sb.toString();
    }

    private void dumpDeactivatedComponents(StringBuilder sb) {
        sb.append("--> Deactivated Components\n");
        Joiner.on((String)"\n\t").appendTo(sb, this.deactivatedComponents);
        sb.append("--\n");
    }

    private void dumpBuidableComponents(StringBuilder sb) {
        sb.append("--> Buildable Components\n");
        Set<Name<Object>> buildableNames = this.collectAllBuildableNames(Object.class);
        for (Name name : buildableNames) {
            ImmutableSet<Query<?>> bomQueries;
            sb.append("   ").append(name).append("\n");
            ArrayList allMachinesFor = Lists.newArrayList(this.findAllMachinesFor(name));
            if (allMachinesFor.isEmpty()) {
                sb.append("      ERROR: machine ").append(this.findAllMachinesListing(name)).append("\n       lists this name in nameBuildableComponents() ").append("but doesn't properly implement canBuild()\n");
                continue;
            }
            FactoryMachine machineFor = (FactoryMachine)allMachinesFor.get(0);
            MachineEngine engine = machineFor.getEngine(name);
            sb.append("      BUILD BY: ").append(engine).append("\n");
            if (allMachinesFor.size() > 1) {
                sb.append("      OVERRIDING:\n");
                for (FactoryMachine machine : allMachinesFor.subList(1, allMachinesFor.size())) {
                    sb.append("         ").append(machine).append("\n");
                }
            }
            if ((bomQueries = engine.getBillOfMaterial().getQueries()).isEmpty()) continue;
            sb.append("      BOM:\n");
            for (Query query : bomQueries) {
                query = query.bind(this);
                sb.append("        - ").append(query).append("\n");
                try {
                    query.checkSatisfy();
                    for (Name name2 : query.findNames()) {
                        sb.append("          -> ").append(name2).append("\n");
                    }
                }
                catch (UnsatisfiedDependenciesException ex) {
                    sb.append("          ERROR: CAN'T BE SATISFIED: ").append(ex.getMessage()).append("\n");
                }
            }
        }
        sb.append("--\n");
    }

    private Set<String> findUndeclaredMachines() {
        if (!this.usedServiceLoader) {
            return Collections.emptySet();
        }
        Set annotatedMachines = new ConfigurationBuilder().setUrls((Collection)ClasspathHelper.forPackage((String)"", (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new TypeAnnotationsScanner()}).build().getTypesAnnotatedWith(Machine.class);
        LinkedHashSet undeclared = Sets.newLinkedHashSet();
        for (Class annotatedMachine : annotatedMachines) {
            boolean found = false;
            for (FactoryMachine machine : this.machines) {
                if (!annotatedMachine.isAssignableFrom(machine.getClass())) continue;
                found = true;
                break;
            }
            if (found) continue;
            undeclared.add(annotatedMachine.getName());
        }
        return undeclared;
    }

    private List<FactoryMachine> findAllMachinesListing(Name<?> name) {
        ArrayList machinesFor = Lists.newArrayList();
        for (FactoryMachine machine : this.machines) {
            if (!this.nameBuildableComponents(machine, Object.class).contains(name)) continue;
            machinesFor.add(machine);
        }
        return machinesFor;
    }

    private Iterable<FactoryMachine> findAllMachinesFor(Name<?> name) {
        if (!this.checkActive(name)) {
            return Collections.emptyList();
        }
        return Iterables.filter(this.machines, (Predicate)new CanBuildPredicate(name));
    }

    private <T> Iterable<MachineEngine<T>> findAllEnginesFor(final Name<T> name) {
        if (!this.checkActive(name)) {
            return Collections.emptyList();
        }
        return Ordering.from(ENGINE_COMPARATOR).sortedCopy(Iterables.transform((Iterable)Iterables.filter(this.machines, (Predicate)new CanBuildPredicate(name)), (Function)new Function<FactoryMachine, MachineEngine<T>>(){

            public MachineEngine<T> apply(FactoryMachine input) {
                return input.getEngine(name);
            }
        }));
    }

    private <T> Optional<MachineEngine<T>> findMachineEngineFor(Name<T> name) {
        return Optional.fromNullable((Object)Iterables.getFirst(this.findAllEnginesFor(name), null));
    }

    private <T> MachineEngine<T> getMachineEngineFor(Name<T> name) {
        Optional<MachineEngine<T>> engineFor = this.findMachineEngineFor(name);
        if (!engineFor.isPresent()) {
            throw UnsatisfiedDependency.on(Query.byName(name)).causedBy(this.machineNotFoundMessage(name)).raise();
        }
        return (MachineEngine)engineFor.get();
    }

    private <T> Set<Name<T>> collectAllBuildableNames(Class<T> componentClass) {
        LinkedHashSet buildableNames = Sets.newLinkedHashSet();
        for (FactoryMachine machine : this.machines) {
            buildableNames.addAll(this.nameBuildableComponents(machine, componentClass));
        }
        return buildableNames;
    }

    private <T> Optional<NamedComponent<T>> buildAndStore(Query<T> query, MachineEngine<T> engine) {
        Name<T> name = engine.getName();
        if (!this.checkActive(name)) {
            return Optional.absent();
        }
        BuildingBox<T> buildingBox = new BuildingBox<T>(ImmutableList.of(SatisfiedQuery.of(query, name)), engine);
        Deque<BuildingBox<?>> dependencies = this.buildBuildingBoxesClosure(buildingBox);
        logger.debug("{} - dependencies closure for {} is: {}", new Object[]{this.id, name, dependencies});
        this.satisfyBoms(dependencies);
        return this.buildAndStore(buildingBox);
    }

    private Deque<BuildingBox<?>> buildBuildingBoxesClosure(BuildingBox<?> buildingBox) {
        LinkedList dependenciesWithNoIncomingEdges = new LinkedList();
        HashMap dependenciesByName = new HashMap();
        LinkedList dependenciesToSatisfy = new LinkedList(Arrays.asList(buildingBox));
        while (!dependenciesToSatisfy.isEmpty()) {
            BuildingBox buildingBox1 = (BuildingBox)dependenciesToSatisfy.poll();
            ImmutableSet<Query<?>> queries = buildingBox1.engine.getBillOfMaterial().getQueries();
            for (Query query : queries) {
                this.buildBuildingBoxClosureForQuery(dependenciesByName, dependenciesToSatisfy, buildingBox1, query);
            }
            if (!buildingBox1.names.isEmpty()) continue;
            dependenciesWithNoIncomingEdges.add(buildingBox1);
        }
        ArrayDeque dependencies = new ArrayDeque();
        while (!dependenciesWithNoIncomingEdges.isEmpty()) {
            BuildingBox n = (BuildingBox)dependenciesWithNoIncomingEdges.removeFirst();
            dependencies.addLast(n);
            while (!n.predecessorsToSort.isEmpty()) {
                BuildingBox<?> m = n.predecessorsToSort.removeFirst();
                m.depsToSort.remove(n);
                if (!m.depsToSort.isEmpty()) continue;
                dependenciesWithNoIncomingEdges.add(m);
            }
        }
        return dependencies;
    }

    private <D> void buildBuildingBoxClosureForQuery(Map<Name<?>, BuildingBox<?>> dependenciesByName, Queue<BuildingBox<?>> dependenciesToSatisfy, BuildingBox<?> buildingBox, Query<D> query) {
        Set<Name<D>> names = query.bind(this).findNames();
        if (names.isEmpty() && query.isMandatory()) {
            Set<Name> similarNames = this.findSimilarNamesByNamedType(query.getComponentClass());
            if (similarNames.isEmpty()) {
                throw UnsatisfiedDependency.on(buildingBox.hierarchy, query).raise();
            }
            throw UnsatisfiedDependency.on(buildingBox.hierarchy, query, this.machineNotFoundMessage(query, similarNames)).raise();
        }
        for (Name<D> n : names) {
            BuildingBox<Object> buildingBox2 = this.getDependencyBuildingBox(dependenciesByName, n);
            if (buildingBox2 != null) {
                buildingBox.addName(query, n, buildingBox2);
                continue;
            }
            Optional<MachineEngine<D>> machineFor = this.findMachineEngineFor(n);
            if (!machineFor.isPresent()) {
                if (!query.isMandatory() || names.size() != 1) continue;
                throw UnsatisfiedDependency.on(buildingBox.hierarchy, query, this.machineNotFoundMessage(n)).raise();
            }
            buildingBox2 = new BuildingBox(ImmutableList.builder().addAll(buildingBox.hierarchy).add(SatisfiedQuery.of(query, n)).build(), (MachineEngine)machineFor.get());
            dependenciesToSatisfy.add(buildingBox2);
            buildingBox.addName(query, n, buildingBox2);
            dependenciesByName.put(n, buildingBox2);
        }
    }

    private <D> BuildingBox<D> getDependencyBuildingBox(Map<Name<?>, BuildingBox<?>> dependenciesByName, Name<D> n) {
        return dependenciesByName.get(n);
    }

    private Set<Name> findSimilarNamesByNamedType(Class componentClass) {
        LinkedHashSet<Name> names = new LinkedHashSet<Name>();
        for (Name<?> name : this.warehouse.listNames()) {
            if (!name.getName().equals(componentClass.getName())) continue;
            names.add(name);
        }
        return names;
    }

    private void satisfyBoms(Deque<BuildingBox<?>> dependencies) {
        BuildingBox<?> buildingBox = dependencies.pollFirst();
        while (buildingBox != null) {
            if (buildingBox.engine.getBillOfMaterial().getQueries().isEmpty()) {
                buildingBox.satisfiedBOM = new SatisfiedBOM(buildingBox.engine.getBillOfMaterial(), ImmutableMultimap.of());
            } else {
                ImmutableListMultimap.Builder materials = ImmutableListMultimap.builder();
                for (Query key : buildingBox.engine.getBillOfMaterial().getQueries()) {
                    Collection names = buildingBox.names.get((Object)key);
                    TreeSet components = Sets.newTreeSet(NAMED_COMPONENT_COMPARATOR);
                    for (Name name : names) {
                        this.uncheckedAddIfPresent(components, this.buildAndStore(this.getDependencyBuildingBox(buildingBox.deps, name)));
                    }
                    materials.putAll((Object)key, (Iterable)components);
                }
                buildingBox.satisfiedBOM = new SatisfiedBOM(buildingBox.engine.getBillOfMaterial(), materials.build());
            }
            buildingBox = dependencies.pollFirst();
        }
    }

    private <T> Optional<NamedComponent<T>> buildAndStore(BuildingBox<T> buildingBox) {
        Name name = buildingBox.engine.getName();
        if (buildingBox == null) {
            throw new IllegalStateException("problem with dependency resolution order no building box for " + name);
        }
        if (buildingBox.component != null) {
            return Optional.of(buildingBox.component);
        }
        Optional namedComponent = this.warehouse.checkOut(name);
        if (namedComponent.isPresent()) {
            buildingBox.component = (NamedComponent)namedComponent.get();
            return namedComponent;
        }
        SatisfiedBOM satisfiedBOM = buildingBox.satisfiedBOM;
        if (satisfiedBOM == null) {
            if (buildingBox.depsToSort != null && !buildingBox.depsToSort.isEmpty()) {
                StringBuilder circularDependencyLog = new StringBuilder();
                for (BuildingBox<?> boxToSort : buildingBox.depsToSort) {
                    this.buildCircularDependencyLog(circularDependencyLog, boxToSort, (ImmutableSet<Name>)ImmutableSet.of());
                }
                logger.error("Circular dependency detected : \n{}\nPlease, fix this as current RestX DI can't handle cycles.", (Object)circularDependencyLog);
                throw new IllegalStateException("Circular dependency detected : \n" + circularDependencyLog + "\nPlease, fix this as current RestX DI can't handle cycles.");
            }
            throw new IllegalStateException("problem with dependency resolution order " + buildingBox.engine.getBillOfMaterial() + " for " + name + " not yet satisfied");
        }
        namedComponent = this.buildAndStore(name, buildingBox.engine, satisfiedBOM);
        if (namedComponent.isPresent()) {
            buildingBox.component = (NamedComponent)namedComponent.get();
        }
        return namedComponent;
    }

    private void buildCircularDependencyLog(StringBuilder circularDependencyLog, BuildingBox buildingBox, ImmutableSet<Name> alreadyDisplayedComponents) {
        StringBuilder indentation = new StringBuilder();
        for (int i = 0; i < alreadyDisplayedComponents.size(); ++i) {
            indentation.append("  ");
        }
        for (BuildingBox<?> buildingBoxToSort : buildingBox.depsToSort) {
            circularDependencyLog.append(indentation.toString()).append("-> ").append(buildingBox.engine.getName()).append("\n");
            if (alreadyDisplayedComponents.contains(buildingBox.engine.getName())) continue;
            this.buildCircularDependencyLog(circularDependencyLog, buildingBoxToSort, (ImmutableSet<Name>)ImmutableSet.builder().addAll(alreadyDisplayedComponents).add(buildingBox.engine.getName()).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Optional<NamedComponent<T>> buildAndStore(Name<T> name, MachineEngine<T> engine, SatisfiedBOM satisfiedBOM) {
        ComponentBox<T> box;
        logger.debug("{} - building {} with {} / {}", new Object[]{this.id, name, engine, satisfiedBOM});
        Timer timer = this.metrics.timer("<BUILD> " + name.getSimpleName());
        Monitor monitor = timer.time();
        try {
            box = engine.newComponent(satisfiedBOM);
        }
        finally {
            monitor.stop();
        }
        if (box instanceof BoundlessComponentBox && box.pick().isPresent() && ((NamedComponent)box.pick().get()).getComponent() == this) {
            return box.pick();
        }
        ArrayList customizers = Lists.newArrayList();
        for (ComponentCustomizerEngine customizerEngine : this.customizerEngines()) {
            if (!customizerEngine.canCustomize(box.getName())) continue;
            customizers.add(customizerEngine.getCustomizer(box.getName()));
        }
        for (ComponentCustomizer customizer : Ordering.from(customizerComparator).sortedCopy((Iterable)customizers)) {
            monitor = this.metrics.timer("<CUSTOMIZE> " + name.getSimpleName() + " <WITH> " + customizer.getClass().getSimpleName()).time();
            try {
                logger.debug("{} - customizing {} with {}", new Object[]{this.id, name, customizer});
                box = box.customize(customizer);
            }
            finally {
                monitor.stop();
            }
        }
        this.warehouse.checkIn(box, satisfiedBOM);
        return this.warehouse.checkOut(box.getName());
    }

    private Iterable<ComponentCustomizerEngine> customizerEngines() {
        return this.customizerEngines;
    }

    private <T> void checkSatisfy(Name<T> name) {
        BillOfMaterials billOfMaterial = this.getBillOfMaterialsFor(name);
        UnsatisfiedDependencies notSatisfied = UnsatisfiedDependencies.of();
        for (Query query : billOfMaterial.getQueries()) {
            try {
                query.bind(this).checkSatisfy();
            }
            catch (UnsatisfiedDependenciesException e) {
                notSatisfied = notSatisfied.concat(e.getUnsatisfiedDependencies().prepend(SatisfiedQuery.of(Query.byName(name), name)));
            }
        }
        if (!notSatisfied.isEmpty()) {
            throw notSatisfied.raise();
        }
    }

    private <T> BillOfMaterials getBillOfMaterialsFor(Name<T> name) {
        return this.getMachineEngineFor(name).getBillOfMaterial();
    }

    private <T> Set<Name<T>> nameBuildableComponents(FactoryMachine machine, Class<T> componentClass) {
        LinkedHashSet<Name<T>> buildableComponents = new LinkedHashSet<Name<T>>();
        for (Name<T> tName : machine.nameBuildableComponents(componentClass)) {
            if (!this.checkActive(tName)) continue;
            buildableComponents.add(tName);
        }
        return buildableComponents;
    }

    private <T> boolean canBuild(FactoryMachine machine, Name<T> name) {
        return this.checkActive(name) && machine.canBuild(name);
    }

    private <T> boolean checkActive(Name<T> name) {
        if (name.getClazz() == String.class && name.getName().startsWith("restx.activation::")) {
            return true;
        }
        if (this.deactivatedComponents.contains(name)) {
            return false;
        }
        if (this.activatedComponents.contains(name)) {
            return true;
        }
        for (Class<T> aClass = name.getClazz(); aClass != null; aClass = aClass.getSuperclass()) {
            if (!"false".equals(this.queryByName(Name.of(String.class, Factory.activationKey(aClass, name.getName()))).findOneAsComponent().or((Object)"true"))) continue;
            this.deactivatedComponents.add(name);
            return false;
        }
        this.activatedComponents.add(name);
        return true;
    }

    private <T> String machineNotFoundMessage(Name<T> name) {
        Set<Name<T>> similarNames = this.queryByClass(name.getClazz()).findNames();
        return this.machineNotFoundMessage(name, similarNames);
    }

    private String machineNotFoundMessage(Object what, Set similarNames) {
        return what + " can't be satisfied in " + this.id + ": no machine found to build it." + (similarNames.isEmpty() ? "" : " similar components found: " + Joiner.on((String)", ").join((Iterable)similarNames));
    }

    private void uncheckedAddIfPresent(Set components, Optional c) {
        if (c.isPresent()) {
            components.add(c.get());
        }
    }

    private static class FactoryMachinesServiceLoader {
        private static Map<ClassLoader, Iterable<? extends FactoryMachine>> serviceLoaderMachines = new WeakHashMap<ClassLoader, Iterable<? extends FactoryMachine>>();

        private FactoryMachinesServiceLoader() {
        }

        static synchronized Iterable<? extends FactoryMachine> getMachines() {
            ImmutableList factoryMachines;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = FactoryMachinesServiceLoader.class.getClassLoader();
            }
            if ((factoryMachines = serviceLoaderMachines.get(classLoader)) == null) {
                try {
                    factoryMachines = ImmutableList.copyOf(ServiceLoader.load(FactoryMachine.class));
                    serviceLoaderMachines.put(classLoader, (Iterable<? extends FactoryMachine>)factoryMachines);
                }
                catch (ServiceConfigurationError e) {
                    if (e.getMessage().endsWith("not found") || e.getMessage().indexOf("java.lang.NoClassDefFoundError") != -1) {
                        String resources = "";
                        try {
                            resources = "\n\n\t\t>> If the problem persists, check these resources:\n\t\t\t- " + Joiner.on((String)"\n\t\t\t- ").join((Iterator)Iterators.forEnumeration(classLoader.getResources("META-INF/services/restx.factory.FactoryMachine")));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new RuntimeException(e.getMessage() + "." + "\n\t\t>> This may be because you renamed or removed it." + "\n\t\t>> Try to clean and rebuild your application and reload/relaunch." + resources + "\n", e);
                    }
                    throw e;
                }
            }
            return factoryMachines;
        }
    }

    private static class BuildingBox<T> {
        final MachineEngine<T> engine;
        final ImmutableList<SatisfiedQuery<?>> hierarchy;
        final Multimap<Query<?>, Name<?>> names = ArrayListMultimap.create();
        final Map<Name<?>, BuildingBox<?>> deps = new LinkedHashMap();
        final Deque<BuildingBox<?>> depsToSort = new LinkedList();
        final Deque<BuildingBox<?>> predecessorsToSort = new LinkedList();
        SatisfiedBOM satisfiedBOM;
        NamedComponent<T> component;

        BuildingBox(ImmutableList<SatisfiedQuery<?>> hierarchy, MachineEngine<T> engine) {
            this.hierarchy = hierarchy;
            this.engine = engine;
        }

        public String toString() {
            return "BuildingBox{name=" + this.engine.getName() + '}';
        }

        public <D> void addName(Query<D> query, Name<D> name, BuildingBox<D> buildingBox) {
            this.names.put(query, name);
            this.deps.put(name, buildingBox);
            this.depsToSort.add(buildingBox);
            buildingBox.predecessorsToSort.add(this);
        }
    }

    public static class SatisfiedQuery<T> {
        private final Query<T> query;
        private final Name<T> name;

        public static <T> SatisfiedQuery<T> of(Query<T> query, Name<T> name) {
            return new SatisfiedQuery<T>(query, name);
        }

        private SatisfiedQuery(Query<T> query, Name<T> name) {
            this.query = query;
            this.name = name;
        }

        public Query<T> getQuery() {
            return this.query;
        }

        public Name<T> getName() {
            return this.name;
        }

        public String toString() {
            return this.query + " (= " + this.name + ")";
        }
    }

    public static class UnsatisfiedDependenciesException
    extends IllegalStateException {
        private final UnsatisfiedDependencies unsatisfiedDependencies;

        public UnsatisfiedDependenciesException(UnsatisfiedDependencies unsatisfiedDependencies) {
            super(unsatisfiedDependencies.toString());
            this.unsatisfiedDependencies = unsatisfiedDependencies;
        }

        public UnsatisfiedDependencies getUnsatisfiedDependencies() {
            return this.unsatisfiedDependencies;
        }
    }

    public static class UnsatisfiedDependencies {
        private final ImmutableList<UnsatisfiedDependency> unsatisfiedDependencies;

        public static UnsatisfiedDependencies of() {
            return new UnsatisfiedDependencies((ImmutableList<UnsatisfiedDependency>)ImmutableList.of());
        }

        public static UnsatisfiedDependencies of(UnsatisfiedDependency unsatisfiedDependency) {
            return new UnsatisfiedDependencies((ImmutableList<UnsatisfiedDependency>)ImmutableList.of((Object)unsatisfiedDependency));
        }

        private UnsatisfiedDependencies(ImmutableList<UnsatisfiedDependency> unsatisfiedDependencies) {
            this.unsatisfiedDependencies = unsatisfiedDependencies;
        }

        public ImmutableList<UnsatisfiedDependency> getUnsatisfiedDependencies() {
            return this.unsatisfiedDependencies;
        }

        public String toString() {
            return Joiner.on((String)"\n").join(this.unsatisfiedDependencies);
        }

        public boolean isEmpty() {
            return this.unsatisfiedDependencies.isEmpty();
        }

        public UnsatisfiedDependenciesException raise() {
            return new UnsatisfiedDependenciesException(this);
        }

        public <T> UnsatisfiedDependencies prepend(SatisfiedQuery<T> query) {
            ArrayList<UnsatisfiedDependency> deps = new ArrayList<UnsatisfiedDependency>(this.unsatisfiedDependencies.size());
            for (UnsatisfiedDependency unsatisfiedDependency : this.unsatisfiedDependencies) {
                deps.add(unsatisfiedDependency.prepend(query));
            }
            return new UnsatisfiedDependencies((ImmutableList<UnsatisfiedDependency>)ImmutableList.copyOf(deps));
        }

        public UnsatisfiedDependencies concat(UnsatisfiedDependencies other) {
            return new UnsatisfiedDependencies((ImmutableList<UnsatisfiedDependency>)ImmutableList.builder().addAll(this.unsatisfiedDependencies).addAll(other.unsatisfiedDependencies).build());
        }
    }

    public static class UnsatisfiedDependency {
        private final ImmutableList<SatisfiedQuery<?>> path;
        private final Query<?> unsatisfied;
        private final String cause;

        public static <T> UnsatisfiedDependency on(Query<T> unsatisfied) {
            return new UnsatisfiedDependency(ImmutableList.of(), unsatisfied, String.format("component satisfying %s not found.", unsatisfied));
        }

        public static UnsatisfiedDependency on(ImmutableList<SatisfiedQuery<?>> path, Query<?> unsatisfied) {
            return UnsatisfiedDependency.on(path, unsatisfied, String.format("component satisfying %s not found.", unsatisfied));
        }

        public static UnsatisfiedDependency on(ImmutableList<SatisfiedQuery<?>> path, Query<?> unsatisfied, String rootCause) {
            StringBuilder sb = new StringBuilder("\n  ");
            String indent = "    ";
            for (SatisfiedQuery query : path) {
                sb.append(query.getQuery()).append("\n").append(indent).append("|       \\__=> ").append(query.getName()).append("\n").append(indent).append("|\n").append(indent).append("+-> ");
                indent = indent + "  ";
            }
            sb.append(unsatisfied).append("\n").append(indent).append("    |\n").append(indent).append("    +--: ");
            sb.append(rootCause).append("\n");
            return new UnsatisfiedDependency(path, unsatisfied, sb.toString());
        }

        private UnsatisfiedDependency(ImmutableList<SatisfiedQuery<?>> path, Query<?> unsatisfied, String cause) {
            this.path = path;
            this.unsatisfied = unsatisfied;
            this.cause = cause;
        }

        public ImmutableList<SatisfiedQuery<?>> getPath() {
            return this.path;
        }

        public Query<?> getUnsatisfied() {
            return this.unsatisfied;
        }

        public String getCause() {
            return this.cause;
        }

        public String toString() {
            return this.cause;
        }

        public UnsatisfiedDependency causedBy(String cause) {
            return new UnsatisfiedDependency(this.path, this.unsatisfied, cause);
        }

        public UnsatisfiedDependenciesException raise() {
            return new UnsatisfiedDependenciesException(UnsatisfiedDependencies.of(this));
        }

        public <T> UnsatisfiedDependency prepend(SatisfiedQuery<T> query) {
            return new UnsatisfiedDependency(ImmutableList.builder().add(query).addAll(this.path).build(), this.unsatisfied, query + MoreStrings.indent((String)("\n-> " + this.cause), (int)2));
        }
    }

    private final class CanBuildPredicate
    implements Predicate<FactoryMachine> {
        private final Name<?> name;

        private CanBuildPredicate(Name<?> name) {
            this.name = name;
        }

        public boolean apply(FactoryMachine input) {
            return input != null && input.canBuild(this.name);
        }
    }

    public static class ClassQuery<T>
    extends MultipleQuery<T> {
        private final Class<T> componentClass;

        ClassQuery(Class<T> componentClass) {
            this(null, false, componentClass);
        }

        ClassQuery(Factory factory, boolean mandatory, Class<T> componentClass) {
            super(factory, mandatory);
            this.componentClass = componentClass;
        }

        @Override
        public Query<T> bind(Factory factory) {
            return new ClassQuery<T>(factory, this.isMandatory(), this.getComponentClass());
        }

        @Override
        public Query<T> setMandatory(boolean mandatory) {
            return new ClassQuery<T>(this.mayGetFactory(), mandatory, this.getComponentClass());
        }

        @Override
        public Class<T> getComponentClass() {
            return this.componentClass;
        }

        @Override
        protected Set<NamedComponent<T>> doFind() {
            TreeSet components = Sets.newTreeSet(NAMED_COMPONENT_COMPARATOR);
            Factory factory = this.factory();
            for (Name tName : factory.collectAllBuildableNames(this.componentClass)) {
                components.addAll(factory.queryByName(tName).optional().find());
            }
            return components;
        }

        @Override
        public Set<Name<T>> findNames() {
            return this.factory().collectAllBuildableNames(this.componentClass);
        }

        public String toString() {
            return "QueryByClass{componentClass=" + MoreObjects.toString(this.componentClass) + '}';
        }
    }

    public static class NameQuery<T>
    extends SingleQuery<T> {
        private final Name<T> name;

        NameQuery(Name<T> name) {
            this(null, true, name);
        }

        NameQuery(Factory factory, boolean mandatory, Name<T> name) {
            super(factory, mandatory);
            this.name = name;
        }

        @Override
        public Query<T> bind(Factory factory) {
            return new NameQuery<T>(factory, this.isMandatory(), this.getName());
        }

        @Override
        public Query<T> setMandatory(boolean mandatory) {
            return new NameQuery<T>(this.mayGetFactory(), mandatory, this.getName());
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        public Name<T> getName() {
            return this.name;
        }

        @Override
        protected Optional<NamedComponent<T>> doFindOne() {
            Optional<NamedComponent<T>> component = this.factory().warehouse.checkOut(this.name);
            if (component.isPresent()) {
                return component;
            }
            for (MachineEngine engine : this.factory().findAllEnginesFor(this.name)) {
                Optional namedComponent = this.factory().buildAndStore(this, engine);
                if (!namedComponent.isPresent()) continue;
                return namedComponent;
            }
            return Optional.absent();
        }

        @Override
        public Set<Name<T>> findNames() {
            return this.factory().checkActive(this.name) ? Collections.singleton(this.name) : Collections.emptySet();
        }

        @Override
        public Class<T> getComponentClass() {
            return this.name.getClazz();
        }

        public String toString() {
            return "QueryByName{name=" + this.name + '}';
        }
    }

    public static class FactoryQuery
    extends SingleQuery<Factory> {
        FactoryQuery() {
            this(null);
        }

        FactoryQuery(Factory factory) {
            super(factory, true);
        }

        @Override
        public Query<Factory> bind(Factory factory) {
            return new FactoryQuery(factory);
        }

        @Override
        public Query<Factory> setMandatory(boolean mandatory) {
            return this;
        }

        @Override
        protected Optional<NamedComponent<Factory>> doFindOne() {
            return Optional.of(new NamedComponent<Factory>(FACTORY_NAME, this.factory()));
        }

        @Override
        public Set<Name<Factory>> findNames() {
            return Collections.singleton(FACTORY_NAME);
        }

        @Override
        public Class<Factory> getComponentClass() {
            return Factory.class;
        }

        public String toString() {
            return "FactoryQuery";
        }
    }

    public static abstract class SingleQuery<T>
    extends Query<T> {
        protected SingleQuery(Factory factory, boolean mandatory) {
            super(factory, mandatory);
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        protected Set<NamedComponent<T>> doFind() {
            return this.doFindOne().asSet();
        }
    }

    public static abstract class MultipleQuery<T>
    extends Query<T> {
        protected MultipleQuery(Factory factory, boolean mandatory) {
            super(factory, mandatory);
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        protected Optional<NamedComponent<T>> doFindOne() {
            Set components = this.doFind();
            if (components.isEmpty()) {
                return Optional.absent();
            }
            if (components.size() == 1) {
                return Optional.of(components.iterator().next());
            }
            StringBuilder sb = new StringBuilder();
            sb.append("more than one component is available for query ").append(this).append(".\n").append(" Please select which one you want with a more specific query,\n").append(" or by deactivating one of the available components.\n").append(" Available components:\n");
            for (NamedComponent component : components) {
                sb.append(" - ").append(component).append("\n").append("         [Activation key: '").append(Factory.activationKey(component.getName().getClazz(), component.getName().getName())).append("']\n");
            }
            throw UnsatisfiedDependency.on(this).causedBy(sb.toString()).raise();
        }
    }

    public static abstract class Query<T> {
        private final boolean mandatory;
        private final Factory factory;

        public static <T> Query<T> byName(Name<T> name) {
            return new NameQuery<T>(name);
        }

        public static <T> Query<T> byClass(Class<T> componentClass) {
            return new ClassQuery<T>(componentClass);
        }

        public static Query<Factory> factoryQuery() {
            return new FactoryQuery();
        }

        protected Query(Factory factory, boolean mandatory) {
            this.mandatory = mandatory;
            this.factory = factory;
        }

        public abstract Class<T> getComponentClass();

        public abstract Query<T> bind(Factory var1);

        protected Factory factory() {
            return (Factory)Preconditions.checkNotNull((Object)this.factory, (String)"illegal method call while factory is not bound on query %s", (Object[])new Object[]{this});
        }

        protected Factory mayGetFactory() {
            return this.factory;
        }

        public Query<T> mandatory() {
            return this.setMandatory(true);
        }

        public Query<T> optional() {
            return this.setMandatory(false);
        }

        abstract Query<T> setMandatory(boolean var1);

        public boolean isMandatory() {
            return this.mandatory;
        }

        public abstract boolean isMultiple();

        public final Optional<NamedComponent<T>> findOne() {
            return this.doFindOne();
        }

        public final Optional<T> findOneAsComponent() {
            Optional<NamedComponent<T>> namedComponent = this.findOne();
            if (namedComponent.isPresent()) {
                return Optional.of(((NamedComponent)namedComponent.get()).getComponent());
            }
            return Optional.absent();
        }

        public final Set<NamedComponent<T>> find() {
            return this.doFind();
        }

        public final Set<T> findAsComponents() {
            return ImmutableSet.copyOf((Iterable)Iterables.transform(this.find(), NamedComponent.toComponent()));
        }

        public abstract Set<Name<T>> findNames();

        protected abstract Optional<NamedComponent<T>> doFindOne();

        protected abstract Set<NamedComponent<T>> doFind();

        public void checkSatisfy() {
            if (!this.isMandatory()) {
                return;
            }
            Set<Name<T>> names = this.findNames();
            if (names.isEmpty()) {
                throw UnsatisfiedDependency.on(this).raise();
            }
            Factory f = this.factory();
            for (Name<T> name : names) {
                f.checkSatisfy(name);
            }
        }
    }

    public static class Builder {
        private boolean usedServiceLoader;
        private Multimap<String, FactoryMachine> machines = ArrayListMultimap.create();
        private List<Warehouse> providers = new ArrayList<Warehouse>();

        public Builder addFromServiceLoader() {
            this.machines.putAll((Object)Factory.SERVICE_LOADER, FactoryMachinesServiceLoader.getMachines());
            this.usedServiceLoader = true;
            return this;
        }

        public Builder addLocalMachines(LocalMachines localMachines) {
            this.machines.putAll((Object)localMachines.getId(), localMachines.get());
            return this;
        }

        public Builder addMachine(FactoryMachine machine) {
            this.machines.put((Object)"IndividualMachines", (Object)machine);
            return this;
        }

        public Builder addWarehouseProvider(Warehouse warehouse) {
            this.providers.add(warehouse);
            return this;
        }

        public Builder withMetrics(MetricRegistry metrics) {
            this.machines.put((Object)"IndividualMachines", new SingletonFactoryMachine<MetricRegistry>(0, new NamedComponent<MetricRegistry>(METRICS_NAME, metrics)));
            return this;
        }

        public Factory build() {
            Factory factory = new Factory(this.usedServiceLoader, this.machines, ImmutableList.of(), new StdWarehouse((ImmutableList<Warehouse>)ImmutableList.copyOf(this.providers)));
            LinkedHashMap<Name<FactoryMachine>, MachineEngine<FactoryMachine>> toBuild = new LinkedHashMap<Name<FactoryMachine>, MachineEngine<FactoryMachine>>();
            ImmutableList<FactoryMachine> factoryMachines = this.buildFactoryMachines(factory, (ImmutableList<FactoryMachine>)factory.machines, toBuild);
            while (!factoryMachines.isEmpty()) {
                this.machines.putAll((Object)"FactoryMachines", factoryMachines);
                factory = new Factory(this.usedServiceLoader, this.machines, ImmutableList.of(), new StdWarehouse());
                factoryMachines = this.buildFactoryMachines(factory, factoryMachines, toBuild);
            }
            factory = new Factory(this.usedServiceLoader, this.machines, this.buildCustomizerEngines(factory), new StdWarehouse((ImmutableList<Warehouse>)ImmutableList.copyOf(this.providers)));
            return factory;
        }

        private ImmutableList<ComponentCustomizerEngine> buildCustomizerEngines(Factory factory) {
            LinkedHashSet componentCustomizerEngines = new LinkedHashSet();
            for (FactoryMachine machine : factory.machines) {
                Set names = factory.nameBuildableComponents(machine, ComponentCustomizerEngine.class);
                for (Name name : names) {
                    Optional customizer = factory.buildAndStore(Query.byName(name), machine.getEngine(name));
                    componentCustomizerEngines.add(((NamedComponent)customizer.get()).getComponent());
                }
            }
            return ImmutableList.copyOf(componentCustomizerEngines);
        }

        private ImmutableList<FactoryMachine> buildFactoryMachines(Factory factory, ImmutableList<FactoryMachine> factoryMachines, Map<Name<FactoryMachine>, MachineEngine<FactoryMachine>> toBuild) {
            ArrayList machines = new ArrayList();
            UnsatisfiedDependencies notSatisfied = UnsatisfiedDependencies.of();
            LinkedHashMap moreToBuild = new LinkedHashMap();
            for (FactoryMachine machine : factoryMachines) {
                Set names = factory.nameBuildableComponents(machine, FactoryMachine.class);
                for (Name name : names) {
                    MachineEngine engine = machine.getEngine(name);
                    try {
                        machines.add(((NamedComponent)factory.buildAndStore(Query.byName(name), engine).get()).getComponent());
                    }
                    catch (UnsatisfiedDependenciesException e) {
                        moreToBuild.put(name, engine);
                        notSatisfied = notSatisfied.concat(e.getUnsatisfiedDependencies().prepend(SatisfiedQuery.of(Query.byName(name), name)));
                    }
                }
            }
            for (Map.Entry entry : new ArrayList<Map.Entry<Name<FactoryMachine>, MachineEngine<FactoryMachine>>>(toBuild.entrySet())) {
                try {
                    machines.add(((NamedComponent)factory.buildAndStore(Query.byName((Name)entry.getKey()), (MachineEngine)entry.getValue()).get()).getComponent());
                    toBuild.remove(entry.getKey());
                }
                catch (UnsatisfiedDependenciesException e) {
                    notSatisfied = notSatisfied.concat(e.getUnsatisfiedDependencies().prepend(SatisfiedQuery.of(Query.byName((Name)entry.getKey()), (Name)entry.getKey())));
                }
            }
            toBuild.putAll(moreToBuild);
            if (!notSatisfied.isEmpty() && machines.isEmpty()) {
                throw notSatisfied.raise();
            }
            return ImmutableList.copyOf(machines);
        }
    }

    public static class LocalMachines {
        private static final ThreadLocal<String> threadLocals = new ThreadLocal<String>(){

            @Override
            protected String initialValue() {
                return String.format("TL[%s][%03d]", Thread.currentThread().getName(), IDS.incrementAndGet());
            }
        };
        private static final ConcurrentMap<String, LocalMachines> contextLocals = new ConcurrentHashMap<String, LocalMachines>();
        private static final AtomicLong IDS = new AtomicLong();
        private final String id;
        private final List<FactoryMachine> machines = Lists.newArrayList();

        private LocalMachines(String id) {
            this.id = id;
        }

        public static LocalMachines overrideComponents() {
            return LocalMachines.threadLocal();
        }

        public static LocalMachines threadLocal() {
            String id = threadLocals.get();
            LocalMachines localMachines = (LocalMachines)contextLocals.get(id);
            if (localMachines != null) {
                return localMachines;
            }
            localMachines = new LocalMachines(id);
            LocalMachines m = contextLocals.putIfAbsent(id, localMachines);
            if (m != null) {
                return m;
            }
            return localMachines;
        }

        public static LocalMachines threadLocalFrom(String id) {
            LocalMachines localMachines = (LocalMachines)contextLocals.get(id);
            if (localMachines != null) {
                return localMachines;
            }
            return new LocalMachines(id);
        }

        public static LocalMachines contextLocal(String ctxName) {
            contextLocals.putIfAbsent(ctxName, new LocalMachines(String.format("CTX[%s][$03d]", ctxName, IDS.incrementAndGet())));
            return (LocalMachines)contextLocals.get(ctxName);
        }

        public LocalMachines addMachine(FactoryMachine machine) {
            this.machines.add(machine);
            return this;
        }

        public LocalMachines removeMachine(FactoryMachine machine) {
            this.machines.remove(machine);
            return this;
        }

        public void clear() {
            this.machines.clear();
        }

        ImmutableList<FactoryMachine> get() {
            return ImmutableList.copyOf(this.machines);
        }

        public String getId() {
            return this.id;
        }

        public LocalMachines set(String name, Object component) {
            Class<?> aClass = component.getClass();
            this.set(NamedComponent.of(aClass, name, component));
            return this;
        }

        public LocalMachines set(int priority, String name, Object component) {
            Class<?> aClass = component.getClass();
            this.set(priority, NamedComponent.of(aClass, name, component));
            return this;
        }

        public <T> LocalMachines set(Class<T> clazz, String name, T component) {
            this.set(NamedComponent.of(clazz, name, component));
            return this;
        }

        public <T> LocalMachines set(int priority, Class<T> clazz, String name, T component) {
            this.set(priority, NamedComponent.of(clazz, name, component));
            return this;
        }

        public <T> LocalMachines set(NamedComponent<T> namedComponent) {
            this.set(-1000, namedComponent);
            return this;
        }

        public <T> LocalMachines set(int priority, NamedComponent<T> namedComponent) {
            this.addMachine(new SingletonFactoryMachine<T>(priority, namedComponent));
            return this;
        }
    }
}

