/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Preconditions;
import restx.common.MoreObjects;

public final class Name<T> {
    private final String name;
    private final Class<T> clazz;

    public static <T> Name<T> of(Class<T> clazz, String name) {
        return new Name<T>(clazz, name);
    }

    public static <T> Name<T> of(Class<T> clazz) {
        return new Name<T>(clazz, clazz.getSimpleName());
    }

    public Name(Class<T> clazz, String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.clazz = (Class)Preconditions.checkNotNull(clazz);
    }

    public String getSimpleName() {
        String simpleName = this.clazz.getSimpleName();
        if (!simpleName.equalsIgnoreCase(this.name)) {
            simpleName = this.name + "[" + simpleName + "]";
        }
        return simpleName;
    }

    public String asId() {
        return "[" + this.clazz.getName() + "]" + this.name;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public String toString() {
        return "Name{name='" + this.name + '\'' + ", clazz=" + MoreObjects.toString(this.clazz) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Name name1 = (Name)o;
        if (!this.clazz.equals(name1.clazz)) {
            return false;
        }
        return this.name.equals(name1.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.clazz.hashCode();
        return result;
    }
}

