/*
 * Decompiled with CFR 0.152.
 */
package restx.config;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import restx.common.ConfigElement;
import restx.common.RestxConfig;
import restx.common.StdRestxConfig;
import restx.config.ConfigSupplier;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.Factory;
import restx.factory.FactoryMachine;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;
import restx.factory.StdMachineEngine;

@Machine
public class ConsolidatedConfigFactoryMachine
implements FactoryMachine {
    @Override
    public boolean canBuild(Name<?> name) {
        return name.getClazz() == RestxConfig.class;
    }

    @Override
    public <T> MachineEngine<T> getEngine(Name<T> name) {
        if (!this.canBuild(name)) {
            throw new IllegalArgumentException("unsuported name " + name);
        }
        return new StdMachineEngine<RestxConfig>(name, this.priority(), BoundlessComponentBox.FACTORY){
            private final Factory.Query<ConfigSupplier> configSupplierQuery;
            private final Factory.Query<String> stringsQuery;
            {
                this.configSupplierQuery = Factory.Query.byClass(ConfigSupplier.class);
                this.stringsQuery = Factory.Query.byClass(String.class);
            }

            @Override
            protected RestxConfig doNewComponent(SatisfiedBOM satisfiedBOM) {
                ArrayList<ConfigElement> elements = new ArrayList<ConfigElement>();
                for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                    if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                    elements.add(ConfigElement.of((String)"system", (String)"", (String)((String)entry.getKey()), (String)((String)entry.getValue())));
                }
                for (NamedComponent namedComponent : satisfiedBOM.get(this.configSupplierQuery)) {
                    Iterables.addAll(elements, (Iterable)((RestxConfig)((ConfigSupplier)namedComponent.getComponent()).get()).elements());
                }
                RestxConfig config = StdRestxConfig.of(elements);
                ArrayList<ConfigElement> arrayList = new ArrayList<ConfigElement>();
                for (NamedComponent<String> s : satisfiedBOM.get(this.stringsQuery)) {
                    Optional element = config.getElement(s.getName().getName());
                    if (element.isPresent() && ((ConfigElement)element.get()).getValue().equals(s.getComponent())) continue;
                    arrayList.add(ConfigElement.of((String)"factory", (String)(element.isPresent() ? ((ConfigElement)element.get()).getDoc() : ""), (String)s.getName().getName(), (String)s.getComponent()));
                }
                return StdRestxConfig.of((Iterable)Iterables.concat(arrayList, elements));
            }

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return BillOfMaterials.of(this.configSupplierQuery, this.stringsQuery);
            }
        };
    }

    @Override
    public <T> Set<Name<T>> nameBuildableComponents(Class<T> componentClass) {
        if (componentClass == RestxConfig.class) {
            return Collections.singleton(Name.of(RestxConfig.class));
        }
        return Collections.emptySet();
    }

    @Override
    public int priority() {
        return 0;
    }

    public String toString() {
        return ConsolidatedConfigFactoryMachine.class.getSimpleName();
    }
}

