/*
 * Decompiled with CFR 0.152.
 */
package restx.config;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import restx.common.ConfigElement;
import restx.common.RestxConfig;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.DefaultFactoryMachine;
import restx.factory.Factory;
import restx.factory.FactoryMachine;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NoDepsMachineEngine;
import restx.factory.SatisfiedBOM;
import restx.factory.StdMachineEngine;

@Machine
public class ElementsFromConfigFactoryMachine
extends DefaultFactoryMachine {
    public ElementsFromConfigFactoryMachine() {
        super(0, new StdMachineEngine<FactoryMachine>(Name.of(FactoryMachine.class, "ElementsFromConfig"), BoundlessComponentBox.FACTORY){
            private Factory.Query<RestxConfig> restxConfigQuery = Factory.Query.byClass(RestxConfig.class).mandatory();

            @Override
            protected FactoryMachine doNewComponent(SatisfiedBOM satisfiedBOM) {
                final RestxConfig config = (RestxConfig)satisfiedBOM.getOneAsComponent(this.restxConfigQuery).get();
                return new FactoryMachine(){

                    @Override
                    public boolean canBuild(Name<?> name) {
                        Optional configElement = config.getElement(name.getName());
                        return configElement.isPresent() && (name.getClazz() == ConfigElement.class || name.getClazz() == String.class && !Strings.isNullOrEmpty((String)((ConfigElement)configElement.get()).getValue()));
                    }

                    @Override
                    public <T> MachineEngine<T> getEngine(final Name<T> name) {
                        return new NoDepsMachineEngine<T>(name, BoundlessComponentBox.FACTORY){

                            @Override
                            protected T doNewComponent(SatisfiedBOM satisfiedBOM) {
                                if (name.getClazz() == String.class) {
                                    return config.getString(name.getName()).get();
                                }
                                if (name.getClazz() == ConfigElement.class) {
                                    return config.getElement(name.getName()).get();
                                }
                                throw new IllegalArgumentException("can't satisfy name " + name);
                            }
                        };
                    }

                    @Override
                    public <T> Set<Name<T>> nameBuildableComponents(Class<T> componentClass) {
                        if (String.class == componentClass) {
                            return Sets.newHashSet((Iterable)Iterables.transform((Iterable)config.elements(), (Function)new Function<ConfigElement, Name<String>>(){

                                public Name<String> apply(ConfigElement input) {
                                    return Name.of(String.class, input.getKey());
                                }
                            }));
                        }
                        if (ConfigElement.class == componentClass) {
                            return Sets.newHashSet((Iterable)Iterables.transform((Iterable)config.elements(), (Function)new Function<ConfigElement, Name<ConfigElement>>(){

                                public Name<ConfigElement> apply(ConfigElement input) {
                                    return Name.of(ConfigElement.class, input.getKey());
                                }
                            }));
                        }
                        return Collections.emptySet();
                    }

                    @Override
                    public int priority() {
                        return 0;
                    }

                    public String toString() {
                        return "ConfigFactoryMachine";
                    }
                };
            }

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return BillOfMaterials.of(this.restxConfigQuery);
            }
        });
    }
}

