/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Set;
import restx.factory.BoundlessComponentBox;
import restx.factory.Factory;
import restx.factory.FactoryMachine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NoDepsMachineEngine;
import restx.factory.SatisfiedBOM;

public class DeactivationFactoryMachine
implements FactoryMachine {
    private final ImmutableSet<String> keys;

    public static DeactivationFactoryMachine forNames(Iterable<Name<?>> names) {
        return new DeactivationFactoryMachine(names);
    }

    public static DeactivationFactoryMachine forNames(Name<?> ... names) {
        return new DeactivationFactoryMachine(Lists.newArrayList((Object[])names));
    }

    public DeactivationFactoryMachine(Iterable<Name<?>> keys) {
        this.keys = ImmutableSet.copyOf((Iterable)Iterables.transform(keys, (Function)new Function<Name<?>, String>(){

            public String apply(Name<?> input) {
                return Factory.activationKey(input.getClazz(), input.getName());
            }
        }));
    }

    @Override
    public boolean canBuild(Name<?> name) {
        return name.getClazz() == String.class && this.keys.contains((Object)name.getName());
    }

    @Override
    public <T> MachineEngine<T> getEngine(Name<T> name) {
        return new NoDepsMachineEngine<T>(name, this.priority(), BoundlessComponentBox.FACTORY){

            @Override
            protected T doNewComponent(SatisfiedBOM satisfiedBOM) {
                return "false";
            }
        };
    }

    @Override
    public <T> Set<Name<T>> nameBuildableComponents(Class<T> componentClass) {
        if (componentClass != String.class) {
            return ImmutableSet.of();
        }
        return Sets.newLinkedHashSet((Iterable)Iterables.transform(this.keys, (Function)new Function<String, Name<T>>(){

            public Name<T> apply(String input) {
                return Name.of(String.class, input);
            }
        }));
    }

    @Override
    public int priority() {
        return -10000;
    }
}

