/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Optional;
import restx.factory.ComponentBox;
import restx.factory.ComponentCustomizer;
import restx.factory.Name;
import restx.factory.NamedComponent;

public class DisposableComponentBox<T>
implements ComponentBox<T> {
    public static final ComponentBox.BoxFactory FACTORY = new ComponentBox.BoxFactory(){

        @Override
        public <T> ComponentBox<T> of(NamedComponent<T> namedComponent) {
            return new DisposableComponentBox<T>(namedComponent);
        }

        public String toString() {
            return "DisposableComponentBox.FACTORY";
        }
    };
    private final Name<T> name;
    private NamedComponent<T> namedComponent;
    private boolean disposed;

    public DisposableComponentBox(NamedComponent<T> namedComponent) {
        this.name = namedComponent.getName();
        this.namedComponent = namedComponent;
    }

    @Override
    public synchronized ComponentBox<T> customize(ComponentCustomizer<T> customizer) {
        if (!this.disposed && this.namedComponent != null) {
            this.namedComponent = customizer.customize(this.namedComponent);
        }
        return this;
    }

    @Override
    public synchronized void close() {
        if (this.namedComponent.getComponent() instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.namedComponent.getComponent()).close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.namedComponent = null;
        this.disposed = true;
    }

    @Override
    public synchronized Optional<NamedComponent<T>> pick() {
        if (this.disposed) {
            return Optional.absent();
        }
        Optional picked = Optional.fromNullable(this.namedComponent);
        this.disposed = true;
        return picked;
    }

    public String toString() {
        return "DisposableComponentBox{name=" + this.name + ", namedComponent=" + this.namedComponent + "}";
    }

    @Override
    public Name<T> getName() {
        return this.name;
    }
}

