/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import java.util.Collections;
import java.util.Set;
import restx.factory.FactoryMachine;
import restx.factory.MachineEngine;
import restx.factory.Name;

public class SingleNameFactoryMachine<C>
implements FactoryMachine {
    private final int priority;
    private final MachineEngine<C> engine;
    private final Name<C> name;

    public SingleNameFactoryMachine(int priority, MachineEngine<C> engine) {
        this.priority = priority;
        this.engine = engine;
        this.name = engine.getName();
    }

    @Override
    public boolean canBuild(Name<?> name) {
        return this.name.equals(name) || this.name.getName().equals(name.getName()) && name.getClazz().isAssignableFrom(this.name.getClazz());
    }

    @Override
    public <T> MachineEngine<T> getEngine(Name<T> name) {
        return this.engine;
    }

    @Override
    public <T> Set<Name<T>> nameBuildableComponents(Class<T> componentClass) {
        if (componentClass.isAssignableFrom(this.name.getClazz())) {
            return Collections.singleton(this.name);
        }
        return Collections.emptySet();
    }

    @Override
    public int priority() {
        return this.priority;
    }

    public String toString() {
        return "SingleNameFactoryMachine{priority=" + this.priority + ", engine=" + this.engine + ", name=" + this.name + "}";
    }
}

