/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.factory.ComponentBox;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;
import restx.factory.Warehouse;

public class StdWarehouse
implements Warehouse {
    private static final AtomicLong ID = new AtomicLong();
    private static final Logger logger = LoggerFactory.getLogger(StdWarehouse.class);
    private final String id;
    private final ConcurrentMap<Name<?>, Warehouse.StoredBox<?>> boxes = new ConcurrentHashMap();
    private final ImmutableList<Warehouse> providers;

    public StdWarehouse() {
        this((ImmutableList<Warehouse>)ImmutableList.of());
    }

    public StdWarehouse(ImmutableList<Warehouse> providers) {
        this.providers = providers;
        StringBuilder sb = new StringBuilder();
        for (Warehouse provider : providers) {
            sb.append("<<").append(provider.getId());
        }
        this.id = String.format("%03d%s", ID.incrementAndGet(), sb.toString());
    }

    @Override
    public ImmutableList<Warehouse> getProviders() {
        return this.providers;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public <T> Optional<Warehouse.StoredBox<T>> getStoredBox(Name<T> name) {
        return Optional.fromNullable((Object)((Warehouse.StoredBox)this.boxes.get(name)));
    }

    @Override
    public <T> Optional<NamedComponent<T>> checkOut(Name<T> name) {
        Warehouse.StoredBox storedBox = (Warehouse.StoredBox)this.boxes.get(name);
        if (storedBox != null) {
            return storedBox.box.pick();
        }
        for (Warehouse provider : this.providers) {
            Optional<NamedComponent<T>> component = provider.checkOut(name);
            if (!component.isPresent()) continue;
            return component;
        }
        return Optional.absent();
    }

    @Override
    public <T> void checkIn(ComponentBox<T> componentBox, SatisfiedBOM satisfiedBOM) {
        Warehouse.StoredBox<T> previousBox = this.boxes.put(componentBox.getName(), new Warehouse.StoredBox<T>(componentBox, satisfiedBOM));
        if (previousBox != null) {
            try {
                previousBox.box.close();
            }
            catch (Exception e) {
                logger.warn("exception raised when closing box " + previousBox.box, (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        ArrayList exceptions = Lists.newArrayList();
        for (Warehouse.StoredBox storedBox : this.boxes.values()) {
            try {
                storedBox.box.close();
            }
            catch (Exception e) {
                logger.warn("exception while closing " + storedBox.box, (Throwable)e);
                exceptions.add(e);
            }
        }
        this.boxes.clear();
        if (!exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                throw new IllegalStateException("exception raised while closing warehouse", (Throwable)exceptions.iterator().next());
            }
            throw new IllegalStateException("exceptions raised when closing warehouse. Exceptions: " + Joiner.on((String)", ").join((Iterable)exceptions));
        }
    }

    @Override
    public Iterable<Name<?>> listNames() {
        LinkedHashSet names = new LinkedHashSet();
        names.addAll(this.boxes.keySet());
        for (Warehouse provider : this.providers) {
            Iterables.addAll(names, provider.listNames());
        }
        return ImmutableSet.copyOf(names);
    }

    @Override
    public Iterable<Name<?>> listDependencies(Name name) {
        Warehouse.StoredBox storedBox = (Warehouse.StoredBox)this.boxes.get(name);
        if (storedBox != null) {
            ArrayList deps = Lists.newArrayList();
            for (NamedComponent<? extends Object> namedComponent : storedBox.satisfiedBOM.getAllComponents()) {
                deps.add(namedComponent.getName());
            }
            return deps;
        }
        for (Warehouse provider : this.providers) {
            Iterable<Name<?>> deps = provider.listDependencies(name);
            if (Iterables.isEmpty(deps)) continue;
            return deps;
        }
        return Collections.emptySet();
    }

    public String toString() {
        return "Warehouse{boxes=" + this.boxes + "; providers=" + this.providers + "}";
    }
}

