/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import restx.factory.ComponentBox;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;

public interface Warehouse
extends AutoCloseable {
    public String getId();

    public ImmutableList<Warehouse> getProviders();

    public <T> Optional<StoredBox<T>> getStoredBox(Name<T> var1);

    public <T> Optional<NamedComponent<T>> checkOut(Name<T> var1);

    public <T> void checkIn(ComponentBox<T> var1, SatisfiedBOM var2);

    public Iterable<Name<?>> listNames();

    public Iterable<Name<?>> listDependencies(Name var1);

    @Override
    public void close();

    public static class StoredBox<T> {
        final ComponentBox<T> box;
        final SatisfiedBOM satisfiedBOM;

        public StoredBox(ComponentBox<T> box, SatisfiedBOM satisfiedBOM) {
            this.box = box;
            this.satisfiedBOM = satisfiedBOM;
        }

        public ComponentBox<T> getBox() {
            return this.box;
        }

        public SatisfiedBOM getSatisfiedBOM() {
            return this.satisfiedBOM;
        }

        public String toString() {
            return "StoredBox{box=" + this.box + ", satisfiedBOM=" + this.satisfiedBOM + "}";
        }
    }
}

