/*
 * Decompiled with CFR 0.152.
 */
package restx.monitor;

import com.google.common.collect.ImmutableSet;
import restx.common.metrics.api.MetricRegistry;
import restx.common.metrics.api.health.HealthCheckRegistry;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.Factory;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;
import restx.factory.SingleNameFactoryMachine;
import restx.factory.StdMachineEngine;
import restx.monitor.MetricsResource;

@Machine
public class MetricsResourceFactoryMachine
extends SingleNameFactoryMachine<MetricsResource> {
    public static final Name<MetricsResource> NAME = Name.of(MetricsResource.class, (String)"MetricsResource");

    public MetricsResourceFactoryMachine() {
        super(0, (MachineEngine)new StdMachineEngine<MetricsResource>(NAME, 0, BoundlessComponentBox.FACTORY){
            private final Factory.Query<MetricRegistry> metricRegistry = Factory.Query.byClass(MetricRegistry.class).mandatory();
            private final Factory.Query<HealthCheckRegistry> healthCheckRegistry = Factory.Query.byClass(HealthCheckRegistry.class).mandatory();

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of(this.metricRegistry, this.healthCheckRegistry));
            }

            protected MetricsResource doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new MetricsResource((MetricRegistry)((NamedComponent)satisfiedBOM.getOne(this.metricRegistry).get()).getComponent(), (HealthCheckRegistry)((NamedComponent)satisfiedBOM.getOne(this.healthCheckRegistry).get()).getComponent());
            }
        });
    }
}

