/*
 * Decompiled with CFR 0.152.
 */
package restx.monitor;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import restx.ResourcesRoute;
import restx.RestxContext;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxRequestMatcher;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.StdRestxRequestMatcher;
import restx.StdRoute;
import restx.factory.Component;
import restx.http.HttpStatus;
import restx.metrics.codahale.CodahaleMetricRegistry;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;

@Component
public class MonitorRouter
extends RestxRouter {
    public MonitorRouter(restx.common.metrics.api.MetricRegistry metricsRegistry, RestxSecurityManager securityManager, PermissionFactory permissionFactory) {
        super("restx-admin", "MonitorRouter", new RestxRoute[]{MonitorRouter.getMonitorUIRoute(), MonitorRouter.getGetMonitorRoute(metricsRegistry, securityManager, permissionFactory)});
    }

    private static StdRoute getGetMonitorRoute(restx.common.metrics.api.MetricRegistry metricRegistry, final RestxSecurityManager securityManager, final PermissionFactory permissionFactory) {
        if (!(metricRegistry instanceof CodahaleMetricRegistry)) {
            throw new IllegalStateException("restx-monitor-admin expects that module restx-monitor-codahale is loaded");
        }
        CodahaleMetricRegistry codahaleMetricRegistry = (CodahaleMetricRegistry)metricRegistry;
        final MetricRegistry metrics = codahaleMetricRegistry.getCodahaleMetricRegistry();
        return new StdRoute("MonitorRoute", (RestxRequestMatcher)new StdRestxRequestMatcher("GET", "/@/monitor")){

            public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
                securityManager.check(req, match, permissionFactory.hasRole("restx-admin"));
                resp.setStatus(HttpStatus.OK);
                resp.setContentType("application/json");
                resp.getWriter().print("[");
                int i = 0;
                for (Map.Entry timerEntry : metrics.getTimers().entrySet()) {
                    String label = (String)timerEntry.getKey();
                    if (label.endsWith("/@/monitor")) continue;
                    Timer timer = (Timer)timerEntry.getValue();
                    if (i != 0) {
                        resp.getWriter().print(",");
                    }
                    double nsPerMs = 1000000.0;
                    resp.getWriter().print(String.format(Locale.ENGLISH, "{ \"id\": %s, \"label\": \"%s\", \"hits\": %s, \"avg\": %.2f, \"lastVal\": %.2f, \"min\": %.2f, \"max\": %.2f, \"active\": %.2f, \"avgActive\": %.2f }", i++, label, timer.getCount(), timer.getSnapshot().getMean() / nsPerMs, timer.getSnapshot().getMedian() / nsPerMs, (double)timer.getSnapshot().getMin() / nsPerMs, (double)timer.getSnapshot().getMax() / nsPerMs, timer.getOneMinuteRate(), timer.getMeanRate()));
                }
                resp.getWriter().print("]");
            }
        };
    }

    private static ResourcesRoute getMonitorUIRoute() {
        return new ResourcesRoute("MonitorUIRoute", "/@/ui/monitor", MonitorRouter.class.getPackage().getName(), ImmutableMap.of((Object)"", (Object)"index.html"));
    }
}

