package restx.monitor;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.monitor.MonitorRouter;

@Machine
public class MonitorRouterFactoryMachine extends SingleNameFactoryMachine<restx.monitor.MonitorRouter> {
    public static final Name<restx.monitor.MonitorRouter> NAME = Name.of(restx.monitor.MonitorRouter.class, "MonitorRouter");

    public MonitorRouterFactoryMachine() {
        super(0, new StdMachineEngine<restx.monitor.MonitorRouter>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.common.metrics.api.MetricRegistry> metricsRegistry = Factory.Query.byClass(restx.common.metrics.api.MetricRegistry.class).mandatory();
private final Factory.Query<restx.security.RestxSecurityManager> securityManager = Factory.Query.byClass(restx.security.RestxSecurityManager.class).mandatory();
private final Factory.Query<restx.security.PermissionFactory> permissionFactory = Factory.Query.byClass(restx.security.PermissionFactory.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
metricsRegistry,
securityManager,
permissionFactory
                ));
            }

            @Override
            protected restx.monitor.MonitorRouter doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new MonitorRouter(
satisfiedBOM.getOne(metricsRegistry).get().getComponent(),
satisfiedBOM.getOne(securityManager).get().getComponent(),
satisfiedBOM.getOne(permissionFactory).get().getComponent()
                );
            }
        });
    }

}
