package restx.monitor;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.monitor.SessionsResource;

@Machine
public class SessionsResourceFactoryMachine extends SingleNameFactoryMachine<restx.monitor.SessionsResource> {
    public static final Name<restx.monitor.SessionsResource> NAME = Name.of(restx.monitor.SessionsResource.class, "SessionsResource");

    public SessionsResourceFactoryMachine() {
        super(0, new StdMachineEngine<restx.monitor.SessionsResource>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.security.Sessions> sessions = Factory.Query.byClass(restx.security.Sessions.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
sessions
                ));
            }

            @Override
            protected restx.monitor.SessionsResource doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new SessionsResource(
satisfiedBOM.getOne(sessions).get().getComponent()
                );
            }
        });
    }

}
