/*
 * Decompiled with CFR 0.152.
 */
package restx.monitor;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Map;
import javax.validation.Validator;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.annotations.GET;
import restx.converters.MainStringConverter;
import restx.description.OperationDescription;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.entity.EntityRequestBodyReaderRegistry;
import restx.entity.EntityResponseWriterRegistry;
import restx.entity.StdEntityRoute;
import restx.exceptions.WrappedCheckedException;
import restx.factory.Component;
import restx.factory.ParamDef;
import restx.http.HttpStatus;
import restx.monitor.MetricsResource;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;
import restx.security.RolesAllowed;

@Component(priority=0)
public class MetricsResourceRouter
extends RestxRouter {
    public MetricsResourceRouter(final MetricsResource resource, EntityRequestBodyReaderRegistry readerRegistry, EntityResponseWriterRegistry writerRegistry, MainStringConverter converter, PermissionFactory pf, Optional<Validator> validator, final RestxSecurityManager securityManager, EndpointParameterMapperRegistry paramMapperRegistry) {
        super("restx-admin", "MetricsResourceRouter", new RestxRoute[]{new StdEntityRoute<Void, Map>("restx-admin#MetricsResource#metrics", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build(Map.class, Optional.absent()), Endpoint.of((String)"GET", (String)"/@/metrics"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[0]){

            protected Optional<Map> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of((Object)resource.metrics());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                operation.responseClass = "MAP";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "";
                operation.outEntityType = Map.class;
                operation.sourceLocation = "restx.monitor.MetricsResource#metrics()";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/metrics";
                    }
                }).build();
            }
        }, new StdEntityRoute<Void, Map>("restx-admin#MetricsResource#healthChecks", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build(Map.class, Optional.absent()), Endpoint.of((String)"GET", (String)"/@/health-checks"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[0]){

            protected Optional<Map> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of((Object)resource.healthChecks());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                operation.responseClass = "MAP";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "";
                operation.outEntityType = Map.class;
                operation.sourceLocation = "restx.monitor.MetricsResource#healthChecks()";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/health-checks";
                    }
                }).build();
            }
        }, new StdEntityRoute<Void, String>("restx-admin#MetricsResource#threadDump", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build(String.class, Optional.absent()), Endpoint.of((String)"GET", (String)"/@/thread-dump"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[0]){

            protected Optional<String> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of((Object)resource.threadDump());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                operation.responseClass = "string";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "";
                operation.outEntityType = String.class;
                operation.sourceLocation = "restx.monitor.MetricsResource#threadDump()";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/thread-dump";
                    }
                }).build();
            }
        }});
    }
}

