/*
 * Decompiled with CFR 0.152.
 */
package samplest.validation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.annotations.POST;
import restx.annotations.PUT;
import restx.annotations.RestxResource;
import restx.factory.Component;
import restx.security.PermitAll;
import restx.validation.ValidatedFor;
import restx.validation.stereotypes.FormValidations;
import samplest.validation.POJO;
import samplest.validation.ValidationResource;

@RestxResource
@Component
public class ValidationResource {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationResource.class);

    @PermitAll
    @POST(value="/valid/pojos")
    public void createPOJOWithoutAnnotation(POJO myPojo) {
        LOG.info("Pojo {} {} created !", (Object)myPojo.getName(), (Object)myPojo.getSubPOJO().getLabel());
    }

    @PermitAll
    @POST(value="/valid/pojos2")
    public void createPOJOWithAnnotation(@ValidatedFor(value={FormValidations.Create.class}) POJO myPojo) {
        LOG.info("Pojo {} {} created !", (Object)myPojo.getName(), (Object)myPojo.getSubPOJO().getLabel());
    }

    @PermitAll
    @PUT(value="/valid/pojos/{id}")
    public void createPOJOWithoutAnnotation(Long id, @ValidatedFor(value={MyCustomValidationGroup.class, FormValidations.Update.class}) POJO myPojo) {
        LOG.info("Pojo {} {} updated !", (Object)myPojo.getName(), (Object)myPojo.getSubPOJO().getLabel());
    }
}

