package restx.server;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.server.Jetty11ServerModule;


@Machine
public class Jetty11ServerModuleFactoryMachine extends DefaultFactoryMachine {
    private static final Jetty11ServerModule module = new Jetty11ServerModule();

    public Jetty11ServerModuleFactoryMachine() {
        super(1000, new MachineEngine[] {
            new StdMachineEngine<java.lang.String>(Name.of(java.lang.String.class, "restx.server.jetty11.webxml.default.location"), 1000, BoundlessComponentBox.FACTORY) {
        private final Factory.Query<java.lang.String> appBase = Factory.Query.byName(Name.of(java.lang.String.class, "restx.server.jetty11.appbase.default.location")).mandatory();
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        appBase
                    ));
                }

                @Override
                public java.lang.String doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.restxServerJettyWebXmlDefaultLocation(
	        satisfiedBOM.getOne(appBase).get().getComponent()
	                    );
                }
            },
            new StdMachineEngine<java.lang.String>(Name.of(java.lang.String.class, "restx.server.jetty11.appbase.default.location"), 1000, BoundlessComponentBox.FACTORY) {
        
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        
                    ));
                }

                @Override
                public java.lang.String doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.restxServerJettyAppBaseDefaultLocation(
	        
	                    );
                }
            },
            new StdMachineEngine<restx.server.WebServerSupplier>(Name.of(restx.server.WebServerSupplier.class, "restx.server.jetty11"), 1000, BoundlessComponentBox.FACTORY) {
        private final Factory.Query<java.lang.String> appBase = Factory.Query.byName(Name.of(java.lang.String.class, "restx.server.jetty11.appbase.default.location")).mandatory();
private final Factory.Query<java.lang.String> webxml = Factory.Query.byName(Name.of(java.lang.String.class, "restx.server.jetty11.webxml.default.location")).mandatory();
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        appBase,
webxml
                    ));
                }

                @Override
                public restx.server.WebServerSupplier doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.jettyWebServerSupplier(
	        satisfiedBOM.getOne(appBase).get().getComponent(),
satisfiedBOM.getOne(webxml).get().getComponent()
	                    );
                }
            },

        });
    }
}
