/*
 * Decompiled with CFR 0.152.
 */
package restx.servlet;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.Duration;
import restx.AbstractResponse;
import restx.RestxResponse;
import restx.http.HttpStatus;
import restx.security.RestxSessionCookieDescriptor;
import restx.servlet.HttpServletRestxRequest;

public class HttpServletRestxResponse
extends AbstractResponse<HttpServletResponse> {
    private final HttpServletResponse resp;
    private final HttpServletRequest request;

    public HttpServletRestxResponse(HttpServletResponse resp, HttpServletRequest request) {
        super(HttpServletResponse.class, (Object)resp);
        this.resp = resp;
        this.request = request;
    }

    protected void doSetStatus(HttpStatus httpStatus) {
        this.resp.setStatus(httpStatus.getCode());
    }

    protected OutputStream doGetOutputStream() throws IOException {
        return this.resp.getOutputStream();
    }

    protected void closeResponse() throws IOException {
    }

    public RestxResponse addCookie(String cookie, String value, RestxSessionCookieDescriptor cookieDescriptor, Duration expiration) {
        Cookie existingCookie = HttpServletRestxRequest.getCookie(this.request.getCookies(), cookie);
        if (existingCookie != null) {
            if (cookieDescriptor.getDomain().isPresent()) {
                existingCookie.setDomain((String)cookieDescriptor.getDomain().get());
            }
            if (cookieDescriptor.getSecure().isPresent()) {
                existingCookie.setSecure(((Boolean)cookieDescriptor.getSecure().get()).booleanValue());
            }
            if ("/".equals(existingCookie.getPath()) || existingCookie.getPath() == null) {
                existingCookie.setPath("/");
                existingCookie.setValue(value);
                existingCookie.setMaxAge(expiration.getStandardSeconds() > 0L ? (int)expiration.getStandardSeconds() : -1);
                this.resp.addCookie(existingCookie);
            } else {
                existingCookie.setValue("");
                existingCookie.setMaxAge(0);
                this.resp.addCookie(existingCookie);
                Cookie c = new Cookie(cookie, value);
                c.setPath("/");
                c.setMaxAge(expiration.getStandardSeconds() > 0L ? (int)expiration.getStandardSeconds() : -1);
                this.resp.addCookie(c);
            }
        } else {
            Cookie c = new Cookie(cookie, value);
            c.setPath("/");
            c.setMaxAge(expiration.getStandardSeconds() > 0L ? (int)expiration.getStandardSeconds() : -1);
            if (cookieDescriptor.getDomain().isPresent()) {
                c.setDomain((String)cookieDescriptor.getDomain().get());
            }
            if (cookieDescriptor.getSecure().isPresent()) {
                c.setSecure(((Boolean)cookieDescriptor.getSecure().get()).booleanValue());
            }
            this.resp.addCookie(c);
        }
        return this;
    }

    public RestxResponse clearCookie(String cookie, RestxSessionCookieDescriptor cookieDescriptor) {
        Cookie existingCookie = HttpServletRestxRequest.getCookie(this.request.getCookies(), cookie);
        if (existingCookie != null) {
            existingCookie.setPath("/");
            existingCookie.setValue("");
            existingCookie.setMaxAge(0);
            if (cookieDescriptor.getDomain().isPresent()) {
                existingCookie.setDomain((String)cookieDescriptor.getDomain().get());
            }
            if (cookieDescriptor.getSecure().isPresent()) {
                existingCookie.setSecure(((Boolean)cookieDescriptor.getSecure().get()).booleanValue());
            }
            this.resp.addCookie(existingCookie);
        }
        return this;
    }

    public void doSetHeader(String headerName, String header) {
        this.resp.setHeader(headerName, header);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz == HttpServletResponse.class || clazz == ServletResponse.class) {
            return (T)this.resp;
        }
        throw new IllegalArgumentException("underlying implementation is HttpServletResponse, not " + clazz.getName());
    }
}

